/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.tree;

import com.google.common.collect.Lists;
import io.atomix.core.cache.CachedPrimitiveBuilder;
import io.atomix.core.tree.AtomicDocumentTree;
import io.atomix.core.tree.AtomicDocumentTreeConfig;
import io.atomix.core.tree.AtomicDocumentTreeType;
import io.atomix.primitive.PrimitiveManagementService;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import io.atomix.primitive.protocol.ProxyCompatibleBuilder;
import io.atomix.primitive.protocol.ProxyProtocol;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.NamespaceConfig;
import io.atomix.utils.serializer.Serializer;
import io.atomix.utils.serializer.SerializerBuilder;

public abstract class AtomicDocumentTreeBuilder<V>
extends CachedPrimitiveBuilder<AtomicDocumentTreeBuilder<V>, AtomicDocumentTreeConfig, AtomicDocumentTree<V>>
implements ProxyCompatibleBuilder<AtomicDocumentTreeBuilder<V>> {
    protected AtomicDocumentTreeBuilder(String name, AtomicDocumentTreeConfig config, PrimitiveManagementService managementService) {
        super(AtomicDocumentTreeType.instance(), name, config, managementService);
    }

    public AtomicDocumentTreeBuilder<V> withProtocol(ProxyProtocol protocol) {
        return (AtomicDocumentTreeBuilder)this.withProtocol((PrimitiveProtocol)protocol);
    }

    public AtomicDocumentTreeBuilder<V> withNodeType(Class<?> nodeType) {
        ((AtomicDocumentTreeConfig)this.config).setNodeType(nodeType);
        return this;
    }

    public AtomicDocumentTreeBuilder<V> withExtraTypes(Class<?> ... extraTypes) {
        ((AtomicDocumentTreeConfig)this.config).setExtraTypes(Lists.newArrayList((Object[])extraTypes));
        return this;
    }

    public AtomicDocumentTreeBuilder<V> addExtraType(Class<?> extraType) {
        ((AtomicDocumentTreeConfig)this.config).addExtraType(extraType);
        return this;
    }

    public AtomicDocumentTreeBuilder<V> withRegistrationRequired() {
        return this.withRegistrationRequired(true);
    }

    public AtomicDocumentTreeBuilder<V> withRegistrationRequired(boolean registrationRequired) {
        ((AtomicDocumentTreeConfig)this.config).setRegistrationRequired(registrationRequired);
        return this;
    }

    public AtomicDocumentTreeBuilder<V> withCompatibleSerialization() {
        return this.withCompatibleSerialization(true);
    }

    public AtomicDocumentTreeBuilder<V> withCompatibleSerialization(boolean compatibleSerialization) {
        ((AtomicDocumentTreeConfig)this.config).setCompatibleSerialization(compatibleSerialization);
        return this;
    }

    protected Serializer serializer() {
        if (this.serializer == null) {
            NamespaceConfig namespaceConfig = ((AtomicDocumentTreeConfig)this.config).getNamespaceConfig();
            if (namespaceConfig == null) {
                namespaceConfig = new NamespaceConfig();
            }
            SerializerBuilder serializerBuilder = this.managementService.getSerializationService().newBuilder(this.name);
            serializerBuilder.withNamespace(new Namespace(namespaceConfig));
            if (((AtomicDocumentTreeConfig)this.config).isRegistrationRequired()) {
                serializerBuilder.withRegistrationRequired();
            }
            if (((AtomicDocumentTreeConfig)this.config).isCompatibleSerialization()) {
                serializerBuilder.withCompatibleSerialization();
            }
            if (((AtomicDocumentTreeConfig)this.config).getNodeType() != null) {
                serializerBuilder.addType(((AtomicDocumentTreeConfig)this.config).getNodeType());
            }
            if (!((AtomicDocumentTreeConfig)this.config).getExtraTypes().isEmpty()) {
                serializerBuilder.withTypes(((AtomicDocumentTreeConfig)this.config).getExtraTypes().toArray(new Class[((AtomicDocumentTreeConfig)this.config).getExtraTypes().size()]));
            }
            this.serializer = serializerBuilder.build();
        }
        return this.serializer;
    }
}

