/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.value;

import com.google.common.collect.Lists;
import io.atomix.core.value.ValueConfig;
import io.atomix.primitive.PrimitiveBuilder;
import io.atomix.primitive.PrimitiveManagementService;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.SyncPrimitive;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.NamespaceConfig;
import io.atomix.utils.serializer.Serializer;
import io.atomix.utils.serializer.SerializerBuilder;

public abstract class ValueBuilder<B extends ValueBuilder<B, C, P, V>, C extends ValueConfig<C>, P extends SyncPrimitive, V>
extends PrimitiveBuilder<B, C, P> {
    protected ValueBuilder(PrimitiveType primitiveType, String name, C config, PrimitiveManagementService managementService) {
        super(primitiveType, name, config, managementService);
    }

    public B withValueType(Class<?> valueType) {
        ((ValueConfig)this.config).setValueType(valueType);
        return (B)((Object)this);
    }

    public B withExtraTypes(Class<?> ... extraTypes) {
        ((ValueConfig)this.config).setExtraTypes(Lists.newArrayList((Object[])extraTypes));
        return (B)((Object)this);
    }

    public B addExtraType(Class<?> extraType) {
        ((ValueConfig)this.config).addExtraType(extraType);
        return (B)((Object)this);
    }

    public B withRegistrationRequired() {
        return this.withRegistrationRequired(true);
    }

    public B withRegistrationRequired(boolean registrationRequired) {
        ((ValueConfig)this.config).setRegistrationRequired(registrationRequired);
        return (B)((Object)this);
    }

    public B withCompatibleSerialization() {
        return this.withCompatibleSerialization(true);
    }

    public B withCompatibleSerialization(boolean compatibleSerialization) {
        ((ValueConfig)this.config).setCompatibleSerialization(compatibleSerialization);
        return (B)((Object)this);
    }

    protected Serializer serializer() {
        if (this.serializer == null) {
            NamespaceConfig namespaceConfig = ((ValueConfig)this.config).getNamespaceConfig();
            if (namespaceConfig == null) {
                namespaceConfig = new NamespaceConfig();
            }
            SerializerBuilder serializerBuilder = this.managementService.getSerializationService().newBuilder(this.name);
            serializerBuilder.withNamespace(new Namespace(namespaceConfig));
            if (((ValueConfig)this.config).isRegistrationRequired()) {
                serializerBuilder.withRegistrationRequired();
            }
            if (((ValueConfig)this.config).isCompatibleSerialization()) {
                serializerBuilder.withCompatibleSerialization();
            }
            if (((ValueConfig)this.config).getValueType() != null) {
                serializerBuilder.addType(((ValueConfig)this.config).getValueType());
            }
            if (!((ValueConfig)this.config).getExtraTypes().isEmpty()) {
                serializerBuilder.withTypes(((ValueConfig)this.config).getExtraTypes().toArray(new Class[((ValueConfig)this.config).getExtraTypes().size()]));
            }
            this.serializer = serializerBuilder.build();
        }
        return this.serializer;
    }
}

