/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.value.impl;

import com.google.common.collect.Sets;
import io.atomix.core.value.AtomicValueType;
import io.atomix.core.value.impl.AtomicValueClient;
import io.atomix.core.value.impl.AtomicValueService;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.service.AbstractPrimitiveService;
import io.atomix.primitive.service.BackupInput;
import io.atomix.primitive.service.BackupOutput;
import io.atomix.primitive.session.Session;
import io.atomix.primitive.session.SessionId;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Serializer;
import java.util.Arrays;
import java.util.Set;

public abstract class AbstractAtomicValueService
extends AbstractPrimitiveService<AtomicValueClient>
implements AtomicValueService {
    private static final Serializer SERIALIZER = Serializer.using((Namespace)Namespace.builder().register(AtomicValueType.instance().namespace()).register(new Class[]{SessionId.class}).build());
    private byte[] value;
    private Set<SessionId> listeners = Sets.newHashSet();

    protected AbstractAtomicValueService(PrimitiveType primitiveType) {
        super(primitiveType, AtomicValueClient.class);
    }

    public Serializer serializer() {
        return SERIALIZER;
    }

    public void backup(BackupOutput writer) {
        ((BackupOutput)writer.writeInt(this.value.length)).writeBytes(this.value);
        writer.writeObject(this.listeners);
    }

    public void restore(BackupInput reader) {
        this.value = reader.readBytes(reader.readInt());
        this.listeners = (Set)reader.readObject();
    }

    private byte[] updateAndNotify(byte[] value) {
        byte[] oldValue = this.value;
        this.value = value;
        this.listeners.forEach(session -> this.getSession((SessionId)session).accept(client -> client.change(value, oldValue)));
        return oldValue;
    }

    @Override
    public void set(byte[] value) {
        if (!Arrays.equals(this.value, value)) {
            this.updateAndNotify(value);
        }
    }

    @Override
    public byte[] get() {
        return this.value;
    }

    @Override
    public boolean compareAndSet(byte[] expect, byte[] update) {
        if (Arrays.equals(this.value, expect)) {
            this.updateAndNotify(update);
            return true;
        }
        return false;
    }

    @Override
    public byte[] getAndSet(byte[] value) {
        if (!Arrays.equals(this.value, value)) {
            return this.updateAndNotify(value);
        }
        return this.value;
    }

    @Override
    public void addListener() {
        this.listeners.add(this.getCurrentSession().sessionId());
    }

    @Override
    public void removeListener() {
        this.listeners.remove(this.getCurrentSession().sessionId());
    }

    protected void onExpire(Session session) {
        this.listeners.remove(session.sessionId());
    }

    protected void onClose(Session session) {
        this.listeners.remove(session.sessionId());
    }
}

