/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.partition;

import io.atomix.primitive.partition.PartitionGroup;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import io.atomix.primitive.protocol.ProxyProtocol;
import java.util.Collection;

public interface PartitionService {
    public PartitionGroup getSystemPartitionGroup();

    public PartitionGroup getPartitionGroup(String var1);

    default public PartitionGroup getPartitionGroup(PrimitiveProtocol.Type type) {
        return this.getPartitionGroups().stream().filter(group -> group.protocol().name().equals(type.name())).findFirst().orElse(null);
    }

    default public PartitionGroup getPartitionGroup(ProxyProtocol protocol) {
        if (protocol.group() != null) {
            PartitionGroup group = this.getPartitionGroup(protocol.group());
            if (group != null) {
                return group;
            }
            PartitionGroup systemGroup = this.getSystemPartitionGroup();
            if (systemGroup != null && systemGroup.name().equals(protocol.group())) {
                return systemGroup;
            }
            return null;
        }
        for (PartitionGroup partitionGroup : this.getPartitionGroups()) {
            if (!partitionGroup.protocol().name().equals(protocol.type().name())) continue;
            return partitionGroup;
        }
        return null;
    }

    public Collection<PartitionGroup> getPartitionGroups();
}

