/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft;

import com.google.common.base.Preconditions;
import io.atomix.cluster.MemberId;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.service.ServiceConfig;
import io.atomix.protocols.raft.RaftMetadataClient;
import io.atomix.protocols.raft.impl.DefaultRaftClient;
import io.atomix.protocols.raft.protocol.RaftClientProtocol;
import io.atomix.protocols.raft.session.RaftSessionClient;
import io.atomix.utils.concurrent.ThreadContextFactory;
import io.atomix.utils.concurrent.ThreadModel;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public interface RaftClient {
    public static Builder builder() {
        return RaftClient.builder(Collections.EMPTY_LIST);
    }

    public static Builder builder(MemberId ... cluster) {
        return RaftClient.builder(Arrays.asList(cluster));
    }

    public static Builder builder(Collection<MemberId> cluster) {
        return new DefaultRaftClient.Builder(cluster);
    }

    public String clientId();

    public long term();

    public MemberId leader();

    public RaftMetadataClient metadata();

    public RaftSessionClient.Builder sessionBuilder(String var1, PrimitiveType var2, ServiceConfig var3);

    default public CompletableFuture<RaftClient> connect() {
        return this.connect((Collection<MemberId>)null);
    }

    default public CompletableFuture<RaftClient> connect(MemberId ... members) {
        if (members == null || members.length == 0) {
            return this.connect();
        }
        return this.connect(Arrays.asList(members));
    }

    public CompletableFuture<RaftClient> connect(Collection<MemberId> var1);

    public CompletableFuture<Void> close();

    public static abstract class Builder
    implements io.atomix.utils.Builder<RaftClient> {
        protected final Collection<MemberId> cluster;
        protected String clientId = UUID.randomUUID().toString();
        protected PartitionId partitionId;
        protected MemberId memberId;
        protected RaftClientProtocol protocol;
        protected ThreadModel threadModel = ThreadModel.SHARED_THREAD_POOL;
        protected int threadPoolSize = Math.max(Math.min(Runtime.getRuntime().availableProcessors() * 2, 16), 4);
        protected ThreadContextFactory threadContextFactory;

        protected Builder(Collection<MemberId> cluster) {
            this.cluster = (Collection)Preconditions.checkNotNull(cluster, (Object)"cluster cannot be null");
        }

        public Builder withClientId(String clientId) {
            this.clientId = (String)Preconditions.checkNotNull((Object)clientId, (Object)"clientId cannot be null");
            return this;
        }

        public Builder withPartitionId(PartitionId partitionId) {
            this.partitionId = (PartitionId)Preconditions.checkNotNull((Object)partitionId, (Object)"partitionId cannot be null");
            return this;
        }

        public Builder withMemberId(MemberId memberId) {
            this.memberId = (MemberId)Preconditions.checkNotNull((Object)memberId, (Object)"memberId cannot be null");
            return this;
        }

        public Builder withProtocol(RaftClientProtocol protocol) {
            this.protocol = (RaftClientProtocol)Preconditions.checkNotNull((Object)protocol, (Object)"protocol cannot be null");
            return this;
        }

        public Builder withThreadModel(ThreadModel threadModel) {
            this.threadModel = (ThreadModel)Preconditions.checkNotNull((Object)threadModel, (Object)"threadModel cannot be null");
            return this;
        }

        public Builder withThreadPoolSize(int threadPoolSize) {
            Preconditions.checkArgument((threadPoolSize > 0 ? 1 : 0) != 0, (Object)"threadPoolSize must be positive");
            this.threadPoolSize = threadPoolSize;
            return this;
        }

        public Builder withThreadContextFactory(ThreadContextFactory threadContextFactory) {
            this.threadContextFactory = (ThreadContextFactory)Preconditions.checkNotNull((Object)threadContextFactory, (Object)"threadContextFactory cannot be null");
            return this;
        }
    }
}

