/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.session.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.cluster.MemberId;
import io.atomix.primitive.PrimitiveState;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.event.EventType;
import io.atomix.primitive.event.PrimitiveEvent;
import io.atomix.primitive.operation.PrimitiveOperation;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.service.ServiceConfig;
import io.atomix.primitive.session.SessionClient;
import io.atomix.primitive.session.SessionId;
import io.atomix.protocols.raft.ReadConsistency;
import io.atomix.protocols.raft.protocol.RaftClientProtocol;
import io.atomix.protocols.raft.session.CommunicationStrategy;
import io.atomix.protocols.raft.session.RaftSessionClient;
import io.atomix.protocols.raft.session.impl.MemberSelectorManager;
import io.atomix.protocols.raft.session.impl.RaftSessionConnection;
import io.atomix.protocols.raft.session.impl.RaftSessionInvoker;
import io.atomix.protocols.raft.session.impl.RaftSessionListener;
import io.atomix.protocols.raft.session.impl.RaftSessionManager;
import io.atomix.protocols.raft.session.impl.RaftSessionSequencer;
import io.atomix.protocols.raft.session.impl.RaftSessionState;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.concurrent.ThreadContext;
import io.atomix.utils.logging.LoggerContext;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class DefaultRaftSessionClient
implements RaftSessionClient {
    private final String serviceName;
    private final PrimitiveType primitiveType;
    private final ServiceConfig serviceConfig;
    private final PartitionId partitionId;
    private final Duration minTimeout;
    private final Duration maxTimeout;
    private final RaftClientProtocol protocol;
    private final MemberSelectorManager selectorManager;
    private final RaftSessionManager sessionManager;
    private final ReadConsistency readConsistency;
    private final CommunicationStrategy communicationStrategy;
    private final ThreadContext context;
    private volatile RaftSessionListener proxyListener;
    private volatile RaftSessionInvoker proxyInvoker;
    private volatile RaftSessionState state;
    private final Consumer<MemberId> leaderChangeListener = this::onLeaderChange;

    public DefaultRaftSessionClient(String serviceName, PrimitiveType primitiveType, ServiceConfig serviceConfig, PartitionId partitionId, RaftClientProtocol protocol, MemberSelectorManager selectorManager, RaftSessionManager sessionManager, ReadConsistency readConsistency, CommunicationStrategy communicationStrategy, ThreadContext context, Duration minTimeout, Duration maxTimeout) {
        this.serviceName = (String)Preconditions.checkNotNull((Object)serviceName, (Object)"serviceName cannot be null");
        this.primitiveType = (PrimitiveType)Preconditions.checkNotNull((Object)primitiveType, (Object)"serviceType cannot be null");
        this.serviceConfig = (ServiceConfig)Preconditions.checkNotNull((Object)serviceConfig, (Object)"serviceConfig cannot be null");
        this.partitionId = (PartitionId)Preconditions.checkNotNull((Object)partitionId, (Object)"partitionId cannot be null");
        this.protocol = (RaftClientProtocol)Preconditions.checkNotNull((Object)protocol, (Object)"protocol cannot be null");
        this.selectorManager = (MemberSelectorManager)Preconditions.checkNotNull((Object)selectorManager, (Object)"selectorManager cannot be null");
        this.readConsistency = (ReadConsistency)((Object)Preconditions.checkNotNull((Object)((Object)readConsistency), (Object)"readConsistency cannot be null"));
        this.communicationStrategy = (CommunicationStrategy)((Object)Preconditions.checkNotNull((Object)((Object)communicationStrategy), (Object)"communicationStrategy cannot be null"));
        this.context = (ThreadContext)Preconditions.checkNotNull((Object)context, (Object)"context cannot be null");
        this.minTimeout = (Duration)Preconditions.checkNotNull((Object)minTimeout, (Object)"minTimeout cannot be null");
        this.maxTimeout = (Duration)Preconditions.checkNotNull((Object)maxTimeout, (Object)"maxTimeout cannot be null");
        this.sessionManager = (RaftSessionManager)Preconditions.checkNotNull((Object)sessionManager, (Object)"sessionManager cannot be null");
    }

    public String name() {
        return this.serviceName;
    }

    public PrimitiveType type() {
        return this.primitiveType;
    }

    public ThreadContext context() {
        return this.context;
    }

    public SessionId sessionId() {
        return this.state != null ? this.state.getSessionId() : null;
    }

    public PartitionId partitionId() {
        return this.partitionId;
    }

    public PrimitiveState getState() {
        return this.state.getState();
    }

    public void addStateChangeListener(Consumer<PrimitiveState> listener) {
        if (this.state != null) {
            this.state.addStateChangeListener(listener);
        }
    }

    public void removeStateChangeListener(Consumer<PrimitiveState> listener) {
        if (this.state != null) {
            this.state.removeStateChangeListener(listener);
        }
    }

    public CompletableFuture<byte[]> execute(PrimitiveOperation operation) {
        RaftSessionInvoker invoker = this.proxyInvoker;
        if (invoker == null) {
            return Futures.exceptionalFuture((Throwable)new IllegalStateException("Session not open"));
        }
        return invoker.invoke(operation);
    }

    public void addEventListener(EventType eventType, Consumer<PrimitiveEvent> listener) {
        if (this.proxyListener != null) {
            this.proxyListener.addEventListener(eventType, listener);
        }
    }

    public void removeEventListener(EventType eventType, Consumer<PrimitiveEvent> listener) {
        if (this.proxyListener != null) {
            this.proxyListener.removeEventListener(eventType, listener);
        }
    }

    public CompletableFuture<SessionClient> connect() {
        return this.sessionManager.openSession(this.serviceName, this.primitiveType, this.serviceConfig, this.readConsistency, this.communicationStrategy, this.minTimeout, this.maxTimeout).thenApply(state -> {
            this.state = state;
            RaftSessionConnection leaderConnection = new RaftSessionConnection(this.protocol, this.selectorManager.createSelector(CommunicationStrategy.LEADER), this.context, LoggerContext.builder(SessionClient.class).addValue((Object)state.getSessionId()).add("type", (Object)state.getPrimitiveType()).add("name", (Object)state.getPrimitiveName()).build());
            RaftSessionConnection sessionConnection = new RaftSessionConnection(this.protocol, this.selectorManager.createSelector(this.communicationStrategy), this.context, LoggerContext.builder(SessionClient.class).addValue((Object)state.getSessionId()).add("type", (Object)state.getPrimitiveType()).add("name", (Object)state.getPrimitiveName()).build());
            RaftSessionSequencer sequencer = new RaftSessionSequencer((RaftSessionState)state);
            this.proxyListener = new RaftSessionListener(this.protocol, this.selectorManager.createSelector(CommunicationStrategy.ANY), (RaftSessionState)state, sequencer, (Executor)this.context);
            this.proxyInvoker = new RaftSessionInvoker(leaderConnection, sessionConnection, (RaftSessionState)state, sequencer, this.sessionManager, this.context);
            this.selectorManager.addLeaderChangeListener(this.leaderChangeListener);
            state.addStateChangeListener(s -> {
                if (s == PrimitiveState.CLOSED) {
                    this.selectorManager.removeLeaderChangeListener(this.leaderChangeListener);
                }
            });
            return this;
        });
    }

    private void onLeaderChange(MemberId memberId) {
        if (memberId != null) {
            this.proxyInvoker.reset();
        }
    }

    public CompletableFuture<Void> close() {
        if (this.state != null) {
            return this.sessionManager.closeSession(this.state.getSessionId(), false).whenComplete((result, error) -> this.state.setState(PrimitiveState.CLOSED));
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> delete() {
        if (this.state != null) {
            return this.sessionManager.closeSession(this.state.getSessionId(), true).whenComplete((result, error) -> this.state.setState(PrimitiveState.CLOSED));
        }
        return CompletableFuture.completedFuture(null);
    }

    public int hashCode() {
        return Objects.hash(this.state);
    }

    public boolean equals(Object object) {
        return object instanceof DefaultRaftSessionClient && ((DefaultRaftSessionClient)object).state.getSessionId() == this.state.getSessionId();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("session", this.state != null ? this.state.getSessionId() : null).toString();
    }
}

