/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.rest.resources;

import com.google.common.collect.Maps;
import io.atomix.primitive.AsyncPrimitive;
import io.atomix.primitive.PrimitiveFactory;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.SyncPrimitive;
import io.atomix.primitive.config.PrimitiveConfig;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

public abstract class PrimitiveResource<P extends AsyncPrimitive, C extends PrimitiveConfig<C>> {
    protected final PrimitiveType type;
    @Context
    protected PrimitiveFactory primitives;

    protected PrimitiveResource(PrimitiveType type) {
        this.type = type;
    }

    protected CompletableFuture<P> getPrimitive(String name) {
        return this.primitives.getPrimitiveAsync(name, this.type).thenApply(primitive -> ((SyncPrimitive)primitive).async());
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    public Response getPrimitives() {
        Map<String, PrimitiveInfo> primitivesInfo = this.primitives.getPrimitives(this.type).stream().map(info -> Maps.immutableEntry((Object)info.name(), (Object)new PrimitiveInfo(info.name(), info.type().name()))).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (PrimitiveInfo)e.getValue()));
        return Response.ok(primitivesInfo).build();
    }

    @POST
    @Path(value="{name}")
    @Consumes(value={"application/json"})
    public void create(@PathParam(value="name") String name, C config, @Suspended AsyncResponse response) {
        this.primitives.getPrimitiveAsync(name, this.type, config).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok().build());
            } else {
                response.resume(error);
            }
        });
    }

    static class PrimitiveInfo {
        private String name;
        private String type;

        PrimitiveInfo(String name, String type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }
    }
}

