/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.gossip.map;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import io.atomix.utils.time.Timestamp;

public class MapValue
implements Comparable<MapValue> {
    private final Timestamp timestamp;
    private final byte[] value;
    private long creationTime;

    public static MapValue tombstone(Timestamp timestamp) {
        return new MapValue(null, timestamp, System.currentTimeMillis());
    }

    public MapValue(byte[] value, Timestamp timestamp) {
        this(value, timestamp, System.currentTimeMillis());
    }

    public MapValue(byte[] value, Timestamp timestamp, long creationTime) {
        this.value = value;
        this.timestamp = (Timestamp)Preconditions.checkNotNull((Object)timestamp, (Object)"Timestamp cannot be null");
        this.creationTime = creationTime;
    }

    public MapValue copy() {
        return new MapValue(this.value, this.timestamp, System.currentTimeMillis());
    }

    public boolean isTombstone() {
        return this.value == null;
    }

    public boolean isAlive() {
        return this.value != null;
    }

    public Timestamp timestamp() {
        return this.timestamp;
    }

    public byte[] get() {
        return this.value;
    }

    public <V> V get(Function<byte[], V> decoder) {
        return (V)decoder.apply((Object)this.value);
    }

    public long creationTime() {
        return this.creationTime;
    }

    public boolean isNewerThan(MapValue other) {
        if (other == null) {
            return true;
        }
        return this.timestamp.isNewerThan(other.timestamp);
    }

    public boolean isNewerThan(Timestamp timestamp) {
        return this.timestamp.isNewerThan(timestamp);
    }

    public Digest digest() {
        return new Digest(this.timestamp, this.isTombstone());
    }

    @Override
    public int compareTo(MapValue o) {
        return this.timestamp.compareTo((Object)o.timestamp);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.timestamp, this.value});
    }

    public boolean equals(Object other) {
        if (other instanceof MapValue) {
            MapValue that = (MapValue)other;
            return Objects.equal((Object)this.timestamp, (Object)that.timestamp) && Objects.equal((Object)this.value, (Object)that.value);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("timestamp", (Object)this.timestamp).add("value", (Object)this.value).toString();
    }

    private MapValue() {
        this.timestamp = null;
        this.value = null;
    }

    public static class Digest {
        private final Timestamp timestamp;
        private final boolean isTombstone;

        public Digest(Timestamp timestamp, boolean isTombstone) {
            this.timestamp = timestamp;
            this.isTombstone = isTombstone;
        }

        public Timestamp timestamp() {
            return this.timestamp;
        }

        public boolean isTombstone() {
            return this.isTombstone;
        }

        public boolean isNewerThan(Digest other) {
            return this.timestamp.isNewerThan(other.timestamp);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.timestamp, this.isTombstone});
        }

        public boolean equals(Object other) {
            if (other instanceof Digest) {
                Digest that = (Digest)other;
                return Objects.equal((Object)this.timestamp, (Object)that.timestamp) && Objects.equal((Object)this.isTombstone, (Object)that.isTombstone);
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("timestamp", (Object)this.timestamp).add("isTombstone", this.isTombstone).toString();
        }
    }
}

