/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.group;

import io.atomix.catalyst.annotations.Beta;
import io.atomix.catalyst.concurrent.Listener;
import io.atomix.catalyst.util.Assert;
import io.atomix.group.DistributedGroupFactory;
import io.atomix.group.GroupMember;
import io.atomix.group.LocalMember;
import io.atomix.group.election.Election;
import io.atomix.group.messaging.MessageClient;
import io.atomix.resource.Resource;
import io.atomix.resource.ResourceTypeInfo;
import java.time.Duration;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

@ResourceTypeInfo(id=-20, factory=DistributedGroupFactory.class)
@Beta
public interface DistributedGroup
extends Resource<DistributedGroup> {
    public Election election();

    public MessageClient messaging();

    public GroupMember member(String var1);

    public Collection<GroupMember> members();

    public CompletableFuture<LocalMember> join();

    public CompletableFuture<LocalMember> join(String var1);

    public CompletableFuture<LocalMember> join(Object var1);

    public CompletableFuture<LocalMember> join(String var1, Object var2);

    public Listener<GroupMember> onJoin(Consumer<GroupMember> var1);

    public CompletableFuture<Void> remove(String var1);

    public Listener<GroupMember> onLeave(Consumer<GroupMember> var1);

    public static class Options
    extends Resource.Options {
        private boolean autoRecover = true;

        public Options() {
        }

        public Options(Properties defaults) {
            super(defaults);
        }

        public Options withAutoRecover(boolean autoRecover) {
            this.setProperty("recover", String.valueOf(autoRecover));
            return this;
        }
    }

    public static class Config
    extends Resource.Config {
        public Config() {
        }

        public Config(Properties defaults) {
            super(defaults);
        }

        public Config withMemberExpiration(Duration expiration) {
            this.setProperty("expiration", String.valueOf(((Duration)Assert.notNull((Object)expiration, (String)"expiration")).toMillis()));
            return this;
        }
    }
}

