/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.group.internal;

import io.atomix.copycat.server.Commit;
import io.atomix.copycat.server.session.ServerSession;
import io.atomix.group.internal.GroupCommands;
import io.atomix.group.internal.GroupMemberInfo;
import io.atomix.group.internal.MessageState;
import io.atomix.group.messaging.internal.GroupMessage;
import java.util.LinkedHashMap;
import java.util.Map;

final class MemberState
implements AutoCloseable {
    private final Commit<GroupCommands.Join> commit;
    private final long index;
    private final String memberId;
    private final boolean persistent;
    private ServerSession session;
    private Object metadata;
    private final Map<Long, MessageState> messages = new LinkedHashMap<Long, MessageState>();

    MemberState(Commit<GroupCommands.Join> commit) {
        this.commit = commit;
        this.index = commit.index();
        this.memberId = ((GroupCommands.Join)commit.operation()).member();
        this.persistent = ((GroupCommands.Join)commit.operation()).persist();
        this.session = commit.session();
        this.metadata = ((GroupCommands.Join)commit.operation()).metadata();
    }

    public long index() {
        return this.index;
    }

    public String id() {
        return this.memberId;
    }

    public GroupMemberInfo info() {
        return new GroupMemberInfo(this.index, this.memberId, this.metadata);
    }

    public ServerSession session() {
        return this.session;
    }

    public void setSession(ServerSession session) {
        this.session = session;
        if (session != null && session.state().active()) {
            for (MessageState message : this.messages.values()) {
                session.publish("message", new GroupMessage<Object>(message.index(), this.memberId, message.queue(), message.message()));
            }
        }
    }

    public boolean persistent() {
        return this.persistent;
    }

    public Object metadata() {
        return this.metadata;
    }

    public void submit(MessageState message) {
        this.messages.put(message.index(), message);
        if (this.session != null && this.session.state().active()) {
            this.session.publish("message", new GroupMessage<Object>(message.index(), this.memberId, message.queue(), message.message()));
        }
    }

    public void reply(MessageState message, GroupCommands.Reply reply) {
        this.messages.remove(message.index());
        message.reply(reply);
    }

    @Override
    public void close() {
        this.messages.values().forEach(MessageState::expire);
        this.commit.close();
    }

    public int hashCode() {
        return this.commit.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof MemberState && ((MemberState)object).id().equals(this.id());
    }
}

