/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.protocol;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.primitive.event.PrimitiveEvent;
import io.atomix.protocols.raft.protocol.SessionRequest;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class PublishRequest
extends SessionRequest {
    private final long eventIndex;
    private final long previousIndex;
    private final List<PrimitiveEvent> events;

    public static Builder builder() {
        return new Builder();
    }

    public PublishRequest(long session, long eventIndex, long previousIndex, List<PrimitiveEvent> events) {
        super(session);
        this.eventIndex = eventIndex;
        this.previousIndex = previousIndex;
        this.events = events;
    }

    public long eventIndex() {
        return this.eventIndex;
    }

    public long previousIndex() {
        return this.previousIndex;
    }

    public List<PrimitiveEvent> events() {
        return this.events;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getClass(), this.session, this.eventIndex, this.previousIndex, this.events);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof PublishRequest) {
            PublishRequest request = (PublishRequest)object;
            return request.session == this.session && request.eventIndex == this.eventIndex && request.previousIndex == this.previousIndex && request.events.equals(this.events);
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("session", this.session).add("eventIndex", this.eventIndex).add("previousIndex", this.previousIndex).add("events", this.events).toString();
    }

    public static class Builder
    extends SessionRequest.Builder<Builder, PublishRequest> {
        private long eventIndex;
        private long previousIndex;
        private List<PrimitiveEvent> events;

        public Builder withEventIndex(long eventIndex) {
            Preconditions.checkArgument((eventIndex > 0L ? 1 : 0) != 0, (Object)"eventIndex must be positive");
            this.eventIndex = eventIndex;
            return this;
        }

        public Builder withPreviousIndex(long previousIndex) {
            Preconditions.checkArgument((previousIndex >= 0L ? 1 : 0) != 0, (Object)"previousIndex must be positive");
            this.previousIndex = previousIndex;
            return this;
        }

        public Builder withEvents(PrimitiveEvent ... events) {
            return this.withEvents(Arrays.asList((Object[])Preconditions.checkNotNull((Object)events, (Object)"events cannot be null")));
        }

        public Builder withEvents(List<PrimitiveEvent> events) {
            this.events = (List)Preconditions.checkNotNull(events, (Object)"events cannot be null");
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            Preconditions.checkArgument((this.eventIndex > 0L ? 1 : 0) != 0, (Object)"eventIndex must be positive");
            Preconditions.checkArgument((this.previousIndex >= 0L ? 1 : 0) != 0, (Object)"previousIndex must be positive");
            Preconditions.checkNotNull(this.events, (Object)"events cannot be null");
        }

        public PublishRequest build() {
            this.validate();
            return new PublishRequest(this.session, this.eventIndex, this.previousIndex, this.events);
        }
    }
}

