/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.roles;

import io.atomix.protocols.raft.RaftError;
import io.atomix.protocols.raft.RaftServer;
import io.atomix.protocols.raft.impl.RaftContext;
import io.atomix.protocols.raft.protocol.AppendRequest;
import io.atomix.protocols.raft.protocol.AppendResponse;
import io.atomix.protocols.raft.protocol.CloseSessionRequest;
import io.atomix.protocols.raft.protocol.CloseSessionResponse;
import io.atomix.protocols.raft.protocol.CommandRequest;
import io.atomix.protocols.raft.protocol.CommandResponse;
import io.atomix.protocols.raft.protocol.ConfigureRequest;
import io.atomix.protocols.raft.protocol.ConfigureResponse;
import io.atomix.protocols.raft.protocol.InstallRequest;
import io.atomix.protocols.raft.protocol.InstallResponse;
import io.atomix.protocols.raft.protocol.JoinRequest;
import io.atomix.protocols.raft.protocol.JoinResponse;
import io.atomix.protocols.raft.protocol.KeepAliveRequest;
import io.atomix.protocols.raft.protocol.KeepAliveResponse;
import io.atomix.protocols.raft.protocol.LeaveRequest;
import io.atomix.protocols.raft.protocol.LeaveResponse;
import io.atomix.protocols.raft.protocol.MetadataRequest;
import io.atomix.protocols.raft.protocol.MetadataResponse;
import io.atomix.protocols.raft.protocol.OpenSessionRequest;
import io.atomix.protocols.raft.protocol.OpenSessionResponse;
import io.atomix.protocols.raft.protocol.PollRequest;
import io.atomix.protocols.raft.protocol.PollResponse;
import io.atomix.protocols.raft.protocol.QueryRequest;
import io.atomix.protocols.raft.protocol.QueryResponse;
import io.atomix.protocols.raft.protocol.RaftResponse;
import io.atomix.protocols.raft.protocol.ReconfigureRequest;
import io.atomix.protocols.raft.protocol.ReconfigureResponse;
import io.atomix.protocols.raft.protocol.TransferRequest;
import io.atomix.protocols.raft.protocol.TransferResponse;
import io.atomix.protocols.raft.protocol.VoteRequest;
import io.atomix.protocols.raft.protocol.VoteResponse;
import io.atomix.protocols.raft.roles.AbstractRole;
import io.atomix.protocols.raft.storage.system.Configuration;
import io.atomix.utils.concurrent.Futures;
import java.util.concurrent.CompletableFuture;

public class InactiveRole
extends AbstractRole {
    public InactiveRole(RaftContext context) {
        super(context);
    }

    @Override
    public RaftServer.Role role() {
        return RaftServer.Role.INACTIVE;
    }

    @Override
    public CompletableFuture<ConfigureResponse> onConfigure(ConfigureRequest request) {
        this.raft.checkThread();
        this.logRequest(request);
        this.updateTermAndLeader(request.term(), request.leader());
        Configuration configuration = new Configuration(request.index(), request.term(), request.timestamp(), request.members());
        this.raft.getCluster().configure(configuration);
        if (this.raft.getCommitIndex() >= this.raft.getCluster().getConfiguration().index()) {
            this.raft.getCluster().commit();
        }
        return CompletableFuture.completedFuture(this.logResponse(((ConfigureResponse.Builder)ConfigureResponse.builder().withStatus(RaftResponse.Status.OK)).build()));
    }

    @Override
    public CompletableFuture<MetadataResponse> onMetadata(MetadataRequest request) {
        this.logRequest(request);
        return Futures.completedFuture((Object)this.logResponse(((MetadataResponse.Builder)((MetadataResponse.Builder)MetadataResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.UNAVAILABLE)).build()));
    }

    @Override
    public CompletableFuture<KeepAliveResponse> onKeepAlive(KeepAliveRequest request) {
        this.logRequest(request);
        return Futures.completedFuture((Object)this.logResponse(((KeepAliveResponse.Builder)((KeepAliveResponse.Builder)KeepAliveResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.UNAVAILABLE)).build()));
    }

    @Override
    public CompletableFuture<OpenSessionResponse> onOpenSession(OpenSessionRequest request) {
        this.logRequest(request);
        return Futures.completedFuture((Object)this.logResponse(((OpenSessionResponse.Builder)((OpenSessionResponse.Builder)OpenSessionResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.UNAVAILABLE)).build()));
    }

    @Override
    public CompletableFuture<CloseSessionResponse> onCloseSession(CloseSessionRequest request) {
        this.logRequest(request);
        return Futures.completedFuture((Object)this.logResponse(((CloseSessionResponse.Builder)((CloseSessionResponse.Builder)CloseSessionResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.UNAVAILABLE)).build()));
    }

    @Override
    public CompletableFuture<InstallResponse> onInstall(InstallRequest request) {
        this.logRequest(request);
        return Futures.completedFuture((Object)this.logResponse(((InstallResponse.Builder)((InstallResponse.Builder)InstallResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.UNAVAILABLE)).build()));
    }

    @Override
    public CompletableFuture<JoinResponse> onJoin(JoinRequest request) {
        this.logRequest(request);
        return Futures.completedFuture((Object)this.logResponse(((JoinResponse.Builder)((JoinResponse.Builder)JoinResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.UNAVAILABLE)).build()));
    }

    @Override
    public CompletableFuture<ReconfigureResponse> onReconfigure(ReconfigureRequest request) {
        this.logRequest(request);
        return Futures.completedFuture((Object)this.logResponse(((ReconfigureResponse.Builder)((ReconfigureResponse.Builder)ReconfigureResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.UNAVAILABLE)).build()));
    }

    @Override
    public CompletableFuture<LeaveResponse> onLeave(LeaveRequest request) {
        this.logRequest(request);
        return Futures.completedFuture((Object)this.logResponse(((LeaveResponse.Builder)((LeaveResponse.Builder)LeaveResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.UNAVAILABLE)).build()));
    }

    @Override
    public CompletableFuture<TransferResponse> onTransfer(TransferRequest request) {
        this.logRequest(request);
        return Futures.completedFuture((Object)this.logResponse(((TransferResponse.Builder)((TransferResponse.Builder)TransferResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.UNAVAILABLE)).build()));
    }

    @Override
    public CompletableFuture<AppendResponse> onAppend(AppendRequest request) {
        this.logRequest(request);
        return Futures.completedFuture((Object)this.logResponse(((AppendResponse.Builder)((AppendResponse.Builder)AppendResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.UNAVAILABLE)).build()));
    }

    @Override
    public CompletableFuture<PollResponse> onPoll(PollRequest request) {
        this.logRequest(request);
        return Futures.completedFuture((Object)this.logResponse(((PollResponse.Builder)((PollResponse.Builder)PollResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.UNAVAILABLE)).build()));
    }

    @Override
    public CompletableFuture<VoteResponse> onVote(VoteRequest request) {
        this.logRequest(request);
        return Futures.completedFuture((Object)this.logResponse(((VoteResponse.Builder)((VoteResponse.Builder)VoteResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.UNAVAILABLE)).build()));
    }

    @Override
    public CompletableFuture<CommandResponse> onCommand(CommandRequest request) {
        this.logRequest(request);
        return Futures.completedFuture((Object)this.logResponse(((CommandResponse.Builder)((CommandResponse.Builder)CommandResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.UNAVAILABLE)).build()));
    }

    @Override
    public CompletableFuture<QueryResponse> onQuery(QueryRequest request) {
        this.logRequest(request);
        return Futures.completedFuture((Object)this.logResponse(((QueryResponse.Builder)((QueryResponse.Builder)QueryResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.UNAVAILABLE)).build()));
    }
}

