/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.manager.internal;

import io.atomix.catalyst.concurrent.Scheduled;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.Operation;
import io.atomix.copycat.server.Commit;
import io.atomix.copycat.server.StateMachineExecutor;
import io.atomix.manager.internal.ResourceManagerStateMachineContext;
import java.time.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ResourceManagerStateMachineExecutor
implements StateMachineExecutor {
    final StateMachineExecutor parent;
    final ResourceManagerStateMachineContext context;
    private final Logger logger;
    private final Map<Class, Function> operations = new HashMap<Class, Function>();
    private final Set<Scheduled> tasks = new HashSet<Scheduled>();

    ResourceManagerStateMachineExecutor(long resource, StateMachineExecutor parent) {
        this.parent = parent;
        this.context = new ResourceManagerStateMachineContext(parent.context());
        this.logger = LoggerFactory.getLogger((String)String.format("%s-%d", this.getClass().getName(), resource));
    }

    public ResourceManagerStateMachineContext context() {
        return this.context;
    }

    public Logger logger() {
        return this.logger;
    }

    public Serializer serializer() {
        return this.parent.serializer();
    }

    public Executor executor() {
        return this.parent.executor();
    }

    public CompletableFuture<Void> execute(Runnable callback) {
        return this.parent.execute(callback);
    }

    public <T> CompletableFuture<T> execute(Supplier<T> callback) {
        return this.parent.execute(callback);
    }

    <T extends Operation<U>, U> U execute(Commit<T> commit) {
        Function function = this.operations.get(commit.type());
        if (function == null) {
            throw new IllegalStateException("unknown state machine operation: " + commit.type());
        }
        return (U)function.apply(commit);
    }

    public Scheduled schedule(Duration delay, Runnable callback) {
        Scheduled task = this.parent.schedule(delay, callback);
        this.tasks.add(task);
        return task;
    }

    public Scheduled schedule(Duration initialDelay, Duration interval, Runnable callback) {
        Scheduled task = this.parent.schedule(initialDelay, interval, callback);
        this.tasks.add(task);
        return task;
    }

    public <T extends Operation<Void>> StateMachineExecutor register(Class<T> type, Consumer<Commit<T>> callback) {
        Assert.notNull(type, (String)"type");
        Assert.notNull(callback, (String)"callback");
        this.operations.put(type, commit -> {
            callback.accept((Commit)commit);
            return null;
        });
        return this;
    }

    public <T extends Operation<U>, U> StateMachineExecutor register(Class<T> type, Function<Commit<T>, U> callback) {
        Assert.notNull(type, (String)"type");
        Assert.notNull(callback, (String)"callback");
        this.operations.put(type, callback);
        return this;
    }

    public void close() {
        this.tasks.forEach(Scheduled::cancel);
        this.context.close();
    }
}

