/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.resource.internal;

import io.atomix.catalyst.concurrent.Listener;
import io.atomix.catalyst.concurrent.ThreadContext;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.transport.Address;
import io.atomix.catalyst.transport.Transport;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.Command;
import io.atomix.copycat.Query;
import io.atomix.copycat.client.CopycatClient;
import io.atomix.copycat.session.Session;
import io.atomix.resource.internal.ResourceCommand;
import io.atomix.resource.internal.ResourceQuery;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class ResourceCopycatClient
implements CopycatClient {
    private final CopycatClient client;

    public ResourceCopycatClient(CopycatClient client) {
        this.client = (CopycatClient)Assert.notNull((Object)client, (String)"client");
    }

    public CopycatClient.State state() {
        return this.client.state();
    }

    public Listener<CopycatClient.State> onStateChange(Consumer<CopycatClient.State> callback) {
        return this.client.onStateChange(callback);
    }

    public ThreadContext context() {
        return this.client.context();
    }

    public Transport transport() {
        return this.client.transport();
    }

    public Serializer serializer() {
        return this.client.serializer();
    }

    public Session session() {
        return this.client.session();
    }

    public <T> CompletableFuture<T> submit(Command<T> command) {
        return this.client.submit(new ResourceCommand(command));
    }

    public <T> CompletableFuture<T> submit(Query<T> query) {
        return this.client.submit(new ResourceQuery(query));
    }

    public Listener<Void> onEvent(String event, Runnable callback) {
        return this.client.onEvent(event, callback);
    }

    public <T> Listener<T> onEvent(String event, Consumer<T> callback) {
        return this.client.onEvent(event, callback);
    }

    public CompletableFuture<CopycatClient> connect(Collection<Address> members) {
        return this.client.connect(members);
    }

    public CompletableFuture<CopycatClient> recover() {
        return this.client.recover();
    }

    public CompletableFuture<Void> close() {
        return this.client.close();
    }
}

