/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.journal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.storage.buffer.Buffer;
import io.atomix.storage.buffer.FileBuffer;
import io.atomix.storage.buffer.HeapBuffer;
import io.atomix.storage.buffer.MappedBuffer;

public final class JournalSegmentDescriptor
implements AutoCloseable {
    public static final int BYTES = 64;
    @VisibleForTesting
    static final int VERSION = 1;
    private static final int VERSION_LENGTH = 4;
    private static final int ID_LENGTH = 8;
    private static final int INDEX_LENGTH = 8;
    private static final int MAX_SIZE_LENGTH = 4;
    private static final int MAX_ENTRIES_LENGTH = 4;
    private static final int UPDATED_LENGTH = 8;
    private static final int VERSION_POSITION = 0;
    private static final int ID_POSITION = 4;
    private static final int INDEX_POSITION = 12;
    private static final int MAX_SIZE_POSITION = 20;
    private static final int MAX_ENTRIES_POSITION = 24;
    private static final int UPDATED_POSITION = 28;
    private volatile Buffer buffer;
    private final int version;
    private final long id;
    private final long index;
    private final int maxSegmentSize;
    private final int maxEntries;
    private volatile long updated;
    private volatile boolean locked;

    public static Builder builder() {
        return new Builder(HeapBuffer.allocate(64));
    }

    public static Builder builder(Buffer buffer) {
        return new Builder(buffer);
    }

    public JournalSegmentDescriptor(Buffer buffer) {
        this.buffer = (Buffer)Preconditions.checkNotNull((Object)buffer, (Object)"buffer cannot be null");
        this.version = buffer.readInt();
        this.id = buffer.readLong();
        this.index = buffer.readLong();
        this.maxSegmentSize = buffer.readInt();
        this.maxEntries = buffer.readInt();
        this.updated = buffer.readLong();
        this.locked = buffer.readBoolean();
        buffer.skip(64 - buffer.position());
    }

    Buffer buffer() {
        return this.buffer;
    }

    public int version() {
        return this.version;
    }

    public long id() {
        return this.id;
    }

    public long index() {
        return this.index;
    }

    public int maxSegmentSize() {
        return this.maxSegmentSize;
    }

    public int maxEntries() {
        return this.maxEntries;
    }

    public long updated() {
        return this.updated;
    }

    public void update(long timestamp) {
        if (!this.locked) {
            this.buffer.writeLong(28, timestamp);
            this.updated = timestamp;
        }
    }

    JournalSegmentDescriptor copyTo(Buffer buffer) {
        this.buffer = (Buffer)buffer.writeInt(this.version).writeLong(this.id).writeLong(this.index).writeInt(this.maxSegmentSize).writeInt(this.maxEntries).writeLong(this.updated).writeBoolean(this.locked).skip(64 - buffer.position()).flush();
        return this;
    }

    @Override
    public void close() {
        this.buffer.close();
    }

    public void delete() {
        if (this.buffer instanceof FileBuffer) {
            ((FileBuffer)this.buffer).delete();
        } else if (this.buffer instanceof MappedBuffer) {
            ((MappedBuffer)this.buffer).delete();
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("version", this.version).add("id", this.id).add("index", this.index).add("updated", this.updated).toString();
    }

    public static class Builder {
        private final Buffer buffer;

        private Builder(Buffer buffer) {
            this.buffer = ((Buffer)Preconditions.checkNotNull((Object)buffer, (Object)"buffer cannot be null")).writeInt(0, 1);
        }

        public Builder withId(long id) {
            this.buffer.writeLong(4, id);
            return this;
        }

        public Builder withIndex(long index) {
            this.buffer.writeLong(12, index);
            return this;
        }

        public Builder withMaxSegmentSize(int maxSegmentSize) {
            this.buffer.writeInt(20, maxSegmentSize);
            return this;
        }

        public Builder withMaxEntries(int maxEntries) {
            this.buffer.writeInt(24, maxEntries);
            return this;
        }

        public JournalSegmentDescriptor build() {
            return new JournalSegmentDescriptor(this.buffer.rewind());
        }
    }
}

