/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.buffer;

import io.atomix.storage.buffer.AbstractBuffer;
import io.atomix.storage.buffer.Buffer;
import io.atomix.storage.buffer.ByteBufferBytes;
import io.atomix.utils.concurrent.ReferenceManager;

public abstract class ByteBufferBuffer
extends AbstractBuffer {
    protected final ByteBufferBytes bytes;

    public ByteBufferBuffer(ByteBufferBytes bytes, ReferenceManager<Buffer> referenceManager) {
        super(bytes, referenceManager);
        this.bytes = bytes;
    }

    public ByteBufferBuffer(ByteBufferBytes bytes, int offset, int initialCapacity, int maxCapacity, ReferenceManager<Buffer> referenceManager) {
        super(bytes, offset, initialCapacity, maxCapacity, referenceManager);
        this.bytes = bytes;
    }

    @Override
    public byte[] array() {
        return this.bytes.array();
    }

    @Override
    protected void compact(int from, int to, int length) {
        int size;
        byte[] bytes = new byte[1024];
        for (int position = from; position < from + length; position += size) {
            size = Math.min(from + length - position, 1024);
            this.bytes.read(position, bytes, 0, size);
            this.bytes.write(0, bytes, 0, size);
        }
    }
}

