/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils.memory;

import io.atomix.utils.memory.Cleaner;
import io.atomix.utils.memory.CleanerJava8;
import io.atomix.utils.memory.CleanerJava9;
import io.atomix.utils.memory.MappedMemoryAllocator;
import io.atomix.utils.memory.NativeMemory;
import java.io.File;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import sun.nio.ch.DirectBuffer;

public class MappedMemory
extends NativeMemory {
    public static final long MAX_SIZE = Integer.MAX_VALUE;
    private final MappedByteBuffer buffer;

    public static MappedMemory allocate(File file, int size) {
        return new MappedMemoryAllocator(file).allocate(size);
    }

    public static MappedMemory allocate(File file, FileChannel.MapMode mode, int size) {
        if ((long)size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("size cannot be greater than 2147483647");
        }
        return new MappedMemoryAllocator(file, mode).allocate(size);
    }

    public MappedMemory(MappedByteBuffer buffer, MappedMemoryAllocator allocator) {
        super(((DirectBuffer)((Object)buffer)).address(), buffer.capacity(), allocator);
        this.buffer = buffer;
    }

    public void flush() {
        this.buffer.force();
    }

    @Override
    public void free() {
        Util.CLEANER.freeDirectBuffer(this.buffer);
        ((MappedMemoryAllocator)this.allocator).release();
    }

    public void close() {
        this.free();
        ((MappedMemoryAllocator)this.allocator).close();
    }

    static class Util {
        static final Cleaner CLEANER;
        private static final Cleaner NOOP;

        Util() {
        }

        private static int majorVersionFromJavaSpecificationVersion() {
            return Util.majorVersion(System.getProperty("java.specification.version", "1.8"));
        }

        private static int majorVersion(String javaSpecVersion) {
            String[] components = javaSpecVersion.split("\\.");
            int[] version = new int[components.length];
            for (int i = 0; i < components.length; ++i) {
                version[i] = Integer.parseInt(components[i]);
            }
            if (version[0] == 1) {
                assert (version[1] >= 8);
                return version[1];
            }
            return version[0];
        }

        static {
            NOOP = buffer -> {};
            CLEANER = Util.majorVersionFromJavaSpecificationVersion() >= 9 ? (CleanerJava9.isSupported() ? new CleanerJava9() : NOOP) : (CleanerJava8.isSupported() ? new CleanerJava8() : NOOP);
        }
    }
}

