/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.buffer;

import io.atomix.catalyst.buffer.AbstractBuffer;
import io.atomix.catalyst.buffer.Buffer;
import io.atomix.catalyst.buffer.Bytes;
import io.atomix.catalyst.buffer.FileBytes;
import io.atomix.catalyst.buffer.MappedBuffer;
import io.atomix.catalyst.buffer.util.Memory;
import io.atomix.catalyst.util.ReferenceManager;
import java.io.File;
import java.nio.channels.FileChannel;

public class FileBuffer
extends AbstractBuffer {
    public static FileBuffer allocate(File file) {
        return FileBuffer.allocate(file, "rw", 4096L, Long.MAX_VALUE);
    }

    public static FileBuffer allocate(File file, long initialCapacity) {
        return FileBuffer.allocate(file, "rw", initialCapacity, Long.MAX_VALUE);
    }

    public static FileBuffer allocate(File file, long initialCapacity, long maxCapacity) {
        return FileBuffer.allocate(file, "rw", initialCapacity, maxCapacity);
    }

    public static FileBuffer allocate(File file, String mode, long initialCapacity, long maxCapacity) {
        return new FileBuffer(new FileBytes(file, mode, Memory.Util.toPow2(initialCapacity)), 0L, initialCapacity, maxCapacity);
    }

    private FileBuffer(Bytes bytes, ReferenceManager<Buffer> referenceManager) {
        super(bytes, referenceManager);
    }

    private FileBuffer(Bytes bytes, long offset, long initialCapacity, long maxCapacity) {
        super(bytes, offset, initialCapacity, maxCapacity, null);
    }

    public File file() {
        return ((FileBytes)this.bytes).file();
    }

    public MappedBuffer map(long size) {
        return this.map(this.position(), size, FileChannel.MapMode.READ_WRITE);
    }

    public MappedBuffer map(long size, FileChannel.MapMode mode) {
        return this.map(this.position(), size, mode);
    }

    public MappedBuffer map(long offset, long size) {
        return this.map(offset, size, FileChannel.MapMode.READ_WRITE);
    }

    public MappedBuffer map(long offset, long size, FileChannel.MapMode mode) {
        return new MappedBuffer(((FileBytes)this.bytes).map(offset, size, mode), 0L, size, size);
    }

    @Override
    protected void compact(long from, long to, long length) {
        long size;
        byte[] bytes = new byte[1024];
        for (long position = from; position < from + length; position += size) {
            size = Math.min(from + length - position, 1024L);
            this.bytes.read(position, bytes, 0L, size);
            this.bytes.write(0L, bytes, 0L, size);
        }
    }

    public void delete() {
        ((FileBytes)this.bytes).delete();
    }
}

