/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.buffer;

import io.atomix.catalyst.buffer.Bytes;
import io.atomix.catalyst.buffer.WrappedBytes;
import java.nio.ByteOrder;

public class SwappedBytes
extends WrappedBytes {
    public SwappedBytes(Bytes bytes) {
        super(bytes);
    }

    @Override
    public ByteOrder order() {
        return this.bytes.order() == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }

    @Override
    public char readChar(long offset) {
        return Character.reverseBytes(this.bytes.readChar(offset));
    }

    @Override
    public short readShort(long offset) {
        return Short.reverseBytes(this.bytes.readShort(offset));
    }

    @Override
    public int readUnsignedShort(long offset) {
        return Short.reverseBytes(this.bytes.readShort(offset)) & 0xFFFF;
    }

    @Override
    public int readMedium(long offset) {
        return Integer.reverseBytes(this.bytes.readMedium(offset));
    }

    @Override
    public int readUnsignedMedium(long offset) {
        return Integer.reverseBytes(this.bytes.readUnsignedMedium(offset));
    }

    @Override
    public int readInt(long offset) {
        return Integer.reverseBytes(this.bytes.readInt(offset));
    }

    @Override
    public long readUnsignedInt(long offset) {
        return (long)Integer.reverseBytes(this.bytes.readInt(offset)) & 0xFFFFFFFFL;
    }

    @Override
    public long readLong(long offset) {
        return Long.reverseBytes(this.bytes.readLong(offset));
    }

    @Override
    public float readFloat(long offset) {
        return Float.intBitsToFloat(this.readInt(offset));
    }

    @Override
    public double readDouble(long offset) {
        return Double.longBitsToDouble(this.readLong(offset));
    }

    @Override
    public Bytes writeChar(long offset, char c) {
        this.bytes.writeChar(offset, Character.reverseBytes(c));
        return this;
    }

    @Override
    public Bytes writeShort(long offset, short s) {
        this.bytes.writeShort(offset, Short.reverseBytes(s));
        return this;
    }

    @Override
    public Bytes writeUnsignedShort(long offset, int s) {
        this.bytes.writeUnsignedShort(offset, Short.reverseBytes((short)s));
        return this;
    }

    @Override
    public Bytes writeMedium(long offset, int m) {
        this.bytes.writeMedium(offset, Integer.reverseBytes(m));
        return this;
    }

    @Override
    public Bytes writeUnsignedMedium(long offset, int m) {
        this.bytes.writeUnsignedMedium(offset, Integer.reverseBytes(m));
        return this;
    }

    @Override
    public Bytes writeInt(long offset, int i) {
        this.bytes.writeInt(offset, Integer.reverseBytes(i));
        return this;
    }

    @Override
    public Bytes writeUnsignedInt(long offset, long i) {
        this.bytes.writeUnsignedInt(offset, Integer.reverseBytes((int)i));
        return this;
    }

    @Override
    public Bytes writeLong(long offset, long l) {
        this.bytes.writeLong(offset, Long.reverseBytes(l));
        return this;
    }

    @Override
    public Bytes writeFloat(long offset, float f) {
        return this.writeInt(offset, Float.floatToRawIntBits(f));
    }

    @Override
    public Bytes writeDouble(long offset, double d) {
        return this.writeLong(offset, Double.doubleToRawLongBits(d));
    }
}

