/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.buffer;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferInputStream;
import java.io.DataInput;
import java.io.IOException;

public class BufferDataInput
extends BufferInputStream
implements DataInput {
    protected final BufferInput<?> buffer;

    public BufferDataInput(BufferInput<?> buffer) {
        super(buffer);
        if (buffer == null) {
            throw new NullPointerException("buffer cannot be null");
        }
        this.buffer = buffer;
    }

    @Override
    public int read() throws IOException {
        return this.buffer.readByte();
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.buffer.read(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.buffer.read(b, (long)off, (long)len);
    }

    @Override
    public int skipBytes(int n) {
        int skipped = Math.min(n, (int)this.buffer.remaining());
        this.buffer.skip(skipped);
        return skipped;
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.buffer.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return (byte)this.buffer.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.buffer.readUnsignedByte();
    }

    @Override
    public short readShort() throws IOException {
        return this.buffer.readShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.buffer.readUnsignedShort();
    }

    @Override
    public char readChar() throws IOException {
        return this.buffer.readChar();
    }

    @Override
    public int readInt() throws IOException {
        return this.buffer.readInt();
    }

    @Override
    public long readLong() throws IOException {
        return this.buffer.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        return this.buffer.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        return this.buffer.readDouble();
    }

    @Override
    public String readLine() throws IOException {
        return this.buffer.readUTF8();
    }

    @Override
    public String readUTF() throws IOException {
        return this.buffer.readUTF8();
    }
}

