/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.util.concurrent;

import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import io.atomix.catalyst.util.concurrent.CatalystThread;
import io.atomix.catalyst.util.concurrent.Runnables;
import io.atomix.catalyst.util.concurrent.Scheduled;
import io.atomix.catalyst.util.concurrent.ThreadContext;
import java.time.Duration;
import java.util.LinkedList;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolContext
implements ThreadContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadPoolContext.class);
    private final ScheduledExecutorService parent;
    private final Serializer serializer;
    private final Runnable runner;
    private final LinkedList<Runnable> tasks = new LinkedList();
    private boolean running;
    private final Executor executor = new Executor(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(Runnable command) {
            LinkedList linkedList = ThreadPoolContext.this.tasks;
            synchronized (linkedList) {
                ThreadPoolContext.this.tasks.add(command);
                if (!ThreadPoolContext.this.running) {
                    ThreadPoolContext.this.running = true;
                    ThreadPoolContext.this.parent.execute(ThreadPoolContext.this.runner);
                }
            }
        }
    };

    public ThreadPoolContext(ScheduledExecutorService parent, Serializer serializer) {
        this.parent = (ScheduledExecutorService)Assert.notNull((Object)parent, (String)"parent");
        this.serializer = (Serializer)Assert.notNull((Object)serializer, (String)"serializer");
        this.runner = () -> {
            ((CatalystThread)Thread.currentThread()).setContext(this);
            while (true) {
                Runnable task;
                LinkedList<Runnable> linkedList = this.tasks;
                synchronized (linkedList) {
                    task = this.tasks.poll();
                    if (task == null) {
                        this.running = false;
                        return;
                    }
                }
                try {
                    task.run();
                }
                catch (Throwable t) {
                    LOGGER.error("An uncaught exception occurred", t);
                    throw t;
                }
            }
        };
    }

    @Override
    public Logger logger() {
        return LOGGER;
    }

    @Override
    public Serializer serializer() {
        return this.serializer;
    }

    @Override
    public Executor executor() {
        return this.executor;
    }

    @Override
    public Scheduled schedule(Duration delay, Runnable runnable) {
        ScheduledFuture<?> future = this.parent.schedule(() -> this.executor.execute(Runnables.logFailure(runnable, LOGGER)), delay.toMillis(), TimeUnit.MILLISECONDS);
        return () -> future.cancel(false);
    }

    @Override
    public Scheduled schedule(Duration delay, Duration interval, Runnable runnable) {
        ScheduledFuture<?> future = this.parent.scheduleAtFixedRate(() -> this.executor.execute(Runnables.logFailure(runnable, LOGGER)), delay.toMillis(), interval.toMillis(), TimeUnit.MILLISECONDS);
        return () -> future.cancel(false);
    }

    @Override
    public void close() {
    }
}

