/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.transport;

import io.atomix.catalyst.buffer.Buffer;
import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.Bytes;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;

final class ByteBufInput
implements BufferInput<ByteBufInput> {
    ByteBuf buffer;

    ByteBufInput() {
    }

    ByteBufInput setByteBuf(ByteBuf buffer) {
        this.buffer = buffer;
        return this;
    }

    public long remaining() {
        return this.buffer.readableBytes();
    }

    public boolean hasRemaining() {
        return this.remaining() > 0L;
    }

    public ByteBufInput skip(long bytes) {
        this.buffer.readerIndex(this.buffer.readerIndex() + (int)bytes);
        return this;
    }

    public ByteBufInput read(Buffer buffer) {
        byte[] bytes = new byte[this.buffer.readableBytes()];
        this.buffer.readBytes(bytes);
        buffer.write(bytes);
        return this;
    }

    public ByteBufInput read(Bytes bytes) {
        byte[] b = new byte[Math.min((int)bytes.size(), this.buffer.readableBytes())];
        this.buffer.readBytes(b);
        bytes.write(0L, b, 0L, (long)b.length);
        return this;
    }

    public ByteBufInput read(byte[] bytes) {
        this.buffer.readBytes(bytes);
        return this;
    }

    public ByteBufInput read(Bytes bytes, long dstOffset, long length) {
        byte[] b = new byte[Math.min((int)length, this.buffer.readableBytes())];
        this.buffer.readBytes(b);
        bytes.write(dstOffset, b, 0L, (long)b.length);
        return this;
    }

    public ByteBufInput read(byte[] bytes, long offset, long length) {
        this.buffer.readBytes(bytes, (int)offset, (int)length);
        return this;
    }

    public int readByte() {
        return this.buffer.readByte();
    }

    public int readUnsignedByte() {
        return this.buffer.readUnsignedByte();
    }

    public char readChar() {
        return this.buffer.readChar();
    }

    public short readShort() {
        return this.buffer.readShort();
    }

    public int readUnsignedShort() {
        return this.buffer.readUnsignedShort();
    }

    public int readInt() {
        return this.buffer.readInt();
    }

    public long readUnsignedInt() {
        return this.buffer.readUnsignedInt();
    }

    public int readMedium() {
        return this.buffer.readMedium();
    }

    public int readUnsignedMedium() {
        return this.buffer.readUnsignedMedium();
    }

    public long readLong() {
        return this.buffer.readLong();
    }

    public float readFloat() {
        return this.buffer.readFloat();
    }

    public double readDouble() {
        return this.buffer.readDouble();
    }

    public boolean readBoolean() {
        return this.buffer.readBoolean();
    }

    public String readString() {
        return this.readUTF8();
    }

    public String readUTF8() {
        byte[] bytes = new byte[this.buffer.readUnsignedShort()];
        this.buffer.readBytes(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public void close() {
    }
}

