/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.transport;

import io.atomix.catalyst.transport.Address;
import io.atomix.catalyst.transport.Client;
import io.atomix.catalyst.transport.Connection;
import io.atomix.catalyst.transport.NettyConnection;
import io.atomix.catalyst.transport.NettyHandler;
import io.atomix.catalyst.util.Assert;
import io.atomix.catalyst.util.concurrent.ComposableFuture;
import io.atomix.catalyst.util.concurrent.ThreadContext;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.LengthFieldPrepender;
import io.netty.util.concurrent.Future;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyClient
implements Client {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyClient.class);
    private static final ByteBufAllocator ALLOCATOR = new PooledByteBufAllocator(true);
    private static final ChannelHandler FIELD_PREPENDER = new LengthFieldPrepender(2);
    private final EventLoopGroup eventLoopGroup;
    private final Map<Channel, NettyConnection> connections = new ConcurrentHashMap<Channel, NettyConnection>();

    public NettyClient(EventLoopGroup eventLoopGroup) {
        this.eventLoopGroup = (EventLoopGroup)Assert.notNull((Object)eventLoopGroup, (String)"eventLoopGroup");
    }

    public CompletableFuture<Connection> connect(Address address) {
        Assert.notNull((Object)address, (String)"address");
        ThreadContext context = ThreadContext.currentContextOrThrow();
        ComposableFuture future = new ComposableFuture();
        LOGGER.info("Connecting to {}", (Object)address);
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)bootstrap.group(this.eventLoopGroup)).channel(this.eventLoopGroup instanceof EpollEventLoopGroup ? EpollSocketChannel.class : NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>((CompletableFuture)future, context){
            final /* synthetic */ CompletableFuture val$future;
            final /* synthetic */ ThreadContext val$context;
            {
                this.val$future = completableFuture;
                this.val$context = threadContext;
            }

            protected void initChannel(SocketChannel channel) throws Exception {
                ChannelPipeline pipeline = channel.pipeline();
                pipeline.addLast(new ChannelHandler[]{FIELD_PREPENDER});
                pipeline.addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(32768, 0, 2, 0, 2)});
                ChannelHandler[] channelHandlerArray = new ChannelHandler[1];
                channelHandlerArray[0] = new NettyHandler(NettyClient.this.connections, this.val$future::complete, this.val$context);
                pipeline.addLast(channelHandlerArray);
            }
        });
        bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true);
        bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)5000);
        bootstrap.option(ChannelOption.ALLOCATOR, (Object)ALLOCATOR);
        bootstrap.connect((SocketAddress)address.socketAddress()).addListener(arg_0 -> NettyClient.lambda$connect$16(address, context, (CompletableFuture)future, arg_0));
        return future;
    }

    public CompletableFuture<Void> close() {
        ThreadContext.currentContextOrThrow();
        int i = 0;
        CompletableFuture[] futures = new CompletableFuture[this.connections.size()];
        for (Connection connection : this.connections.values()) {
            futures[i++] = connection.close();
        }
        return CompletableFuture.allOf(futures);
    }

    private static /* synthetic */ void lambda$connect$16(Address address, ThreadContext threadContext, CompletableFuture completableFuture, Future channelFuture) throws Exception {
        if (channelFuture.isSuccess()) {
            LOGGER.info("Connected to {}", (Object)address);
        } else {
            threadContext.execute(() -> completableFuture.completeExceptionally(channelFuture.cause()));
        }
    }
}

