/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.transport;

import io.atomix.catalyst.transport.Connection;
import io.atomix.catalyst.transport.NettyConnection;
import io.atomix.catalyst.util.concurrent.SingleThreadContext;
import io.atomix.catalyst.util.concurrent.ThreadContext;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;

class NettyHandler
extends ChannelInboundHandlerAdapter {
    private final Map<Channel, NettyConnection> connections;
    private final Consumer<Connection> listener;
    private final ThreadContext context;

    protected NettyHandler(Map<Channel, NettyConnection> connections, Consumer<Connection> listener, ThreadContext context) {
        this.connections = connections;
        this.listener = listener;
        this.context = context;
    }

    protected void setConnection(Channel channel, NettyConnection connection) {
        this.connections.put(channel, connection);
    }

    protected NettyConnection getConnection(Channel channel) {
        return this.connections.get(channel);
    }

    protected NettyConnection removeConnection(Channel channel) {
        return this.connections.remove(channel);
    }

    private ThreadContext getOrCreateContext(Channel channel) {
        ThreadContext context = ThreadContext.currentContext();
        if (context != null) {
            return context;
        }
        return new SingleThreadContext(Thread.currentThread(), (ScheduledExecutorService)channel.eventLoop(), this.context.serializer().clone());
    }

    public void channelActive(ChannelHandlerContext context) throws Exception {
        Channel channel = context.channel();
        NettyConnection connection = new NettyConnection(channel, this.getOrCreateContext(channel));
        this.setConnection(channel, connection);
        this.context.executor().execute(() -> this.listener.accept(connection));
    }

    public void channelRead(ChannelHandlerContext context, Object message) {
        ByteBuf buffer = (ByteBuf)message;
        byte type = buffer.readByte();
        switch (type) {
            case 1: {
                this.handleRequest(buffer, context);
                break;
            }
            case 2: {
                this.handleResponse(buffer, context);
            }
        }
    }

    private void handleRequest(ByteBuf request, ChannelHandlerContext context) {
        NettyConnection connection = this.getConnection(context.channel());
        if (connection != null) {
            connection.handleRequest(request);
        }
    }

    private void handleResponse(ByteBuf response, ChannelHandlerContext context) {
        NettyConnection connection = this.getConnection(context.channel());
        if (connection != null) {
            connection.handleResponse(response);
        }
    }

    public void exceptionCaught(ChannelHandlerContext context, Throwable t) throws Exception {
        Channel channel = context.channel();
        NettyConnection connection = this.getConnection(channel);
        if (connection != null) {
            try {
                if (channel.isOpen()) {
                    channel.close();
                }
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            connection.handleException(t);
        } else {
            channel.close();
        }
    }

    public void channelInactive(ChannelHandlerContext context) throws Exception {
        Channel channel = context.channel();
        NettyConnection connection = this.removeConnection(channel);
        if (connection != null) {
            connection.handleClosed();
        }
    }

    public void userEventTriggered(ChannelHandlerContext context, Object event) throws Exception {
        if (event instanceof IdleStateEvent && ((IdleStateEvent)event).state() == IdleState.ALL_IDLE) {
            context.close();
        }
    }
}

