/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.transport;

import io.atomix.catalyst.transport.Address;
import io.atomix.catalyst.transport.Connection;
import io.atomix.catalyst.transport.NettyConnection;
import io.atomix.catalyst.transport.NettyHandler;
import io.atomix.catalyst.transport.Server;
import io.atomix.catalyst.util.Assert;
import io.atomix.catalyst.util.concurrent.ThreadContext;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.LengthFieldPrepender;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyServer
implements Server {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyServer.class);
    private static final ByteBufAllocator ALLOCATOR = new PooledByteBufAllocator(true);
    private static final ChannelHandler FIELD_PREPENDER = new LengthFieldPrepender(2);
    private final EventLoopGroup eventLoopGroup;
    private final Map<Channel, NettyConnection> connections = new ConcurrentHashMap<Channel, NettyConnection>();
    private ServerHandler handler;
    private ChannelGroup channelGroup;
    private volatile boolean listening;
    private CompletableFuture<Void> listenFuture;

    public NettyServer(EventLoopGroup eventLoopGroup) {
        this.eventLoopGroup = eventLoopGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> listen(Address address, Consumer<Connection> listener) {
        Assert.notNull((Object)address, (String)"address");
        Assert.notNull(listener, (String)"listener");
        if (this.listening) {
            return CompletableFuture.completedFuture(null);
        }
        ThreadContext context = ThreadContext.currentContextOrThrow();
        NettyServer nettyServer = this;
        synchronized (nettyServer) {
            if (this.listenFuture == null) {
                this.listenFuture = new CompletableFuture();
                this.listen(address, listener, context);
            }
        }
        return this.listenFuture;
    }

    private void listen(Address address, Consumer<Connection> listener, ThreadContext context) {
        this.channelGroup = new DefaultChannelGroup("catalyst-acceptor-channels", (EventExecutor)GlobalEventExecutor.INSTANCE);
        this.handler = new ServerHandler(this.connections, listener, context);
        ServerBootstrap bootstrap = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)bootstrap.group(this.eventLoopGroup).channel(this.eventLoopGroup instanceof EpollEventLoopGroup ? EpollServerSocketChannel.class : NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(LogLevel.DEBUG))).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel channel) throws Exception {
                ChannelPipeline pipeline = channel.pipeline();
                pipeline.addLast(new ChannelHandler[]{FIELD_PREPENDER});
                pipeline.addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(32768, 0, 2, 0, 2)});
                pipeline.addLast(new ChannelHandler[]{NettyServer.this.handler});
            }
        }).option(ChannelOption.SO_BACKLOG, (Object)128)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_REUSEADDR, (Object)true)).childOption(ChannelOption.ALLOCATOR, (Object)ALLOCATOR).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        LOGGER.info("Binding to {}", (Object)address);
        ChannelFuture bindFuture = bootstrap.bind((SocketAddress)address.socketAddress());
        bindFuture.addListener((GenericFutureListener)((ChannelFutureListener)channelFuture2 -> {
            if (channelFuture2.isSuccess()) {
                this.listening = true;
                context.executor().execute(() -> {
                    LOGGER.info("Listening at {}", (Object)bindFuture.channel().localAddress());
                    this.listenFuture.complete(null);
                });
            } else {
                context.execute(() -> this.listenFuture.completeExceptionally(channelFuture2.cause()));
            }
        }));
        this.channelGroup.add((Object)bindFuture.channel());
    }

    public CompletableFuture<Void> close() {
        int i = 0;
        CompletableFuture[] futures = new CompletableFuture[this.connections.size()];
        for (Connection connection : this.connections.values()) {
            futures[i++] = connection.close();
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        CompletableFuture.allOf(futures).whenComplete((result, error) -> this.channelGroup.close().addListener(channelFuture -> future.complete(null)));
        return future;
    }

    @ChannelHandler.Sharable
    private static class ServerHandler
    extends NettyHandler {
        private ServerHandler(Map<Channel, NettyConnection> connections, Consumer<Connection> listener, ThreadContext context) {
            super(connections, listener, context);
        }
    }
}

