/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.transport;

import io.atomix.catalyst.transport.Client;
import io.atomix.catalyst.transport.NettyClient;
import io.atomix.catalyst.transport.NettyServer;
import io.atomix.catalyst.transport.Server;
import io.atomix.catalyst.transport.Transport;
import io.atomix.catalyst.util.Assert;
import io.atomix.catalyst.util.concurrent.CatalystThreadFactory;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.util.concurrent.ThreadFactory;

public class NettyTransport
implements Transport {
    private final EventLoopGroup eventLoopGroup;

    public NettyTransport() {
        this(Runtime.getRuntime().availableProcessors());
    }

    public NettyTransport(int threads) {
        Assert.arg((threads > 0 ? 1 : 0) != 0, (String)"threads must be positive", (Object[])new Object[0]);
        CatalystThreadFactory threadFactory = new CatalystThreadFactory("catalyst-event-loop-%d");
        this.eventLoopGroup = Epoll.isAvailable() ? new EpollEventLoopGroup(threads, (ThreadFactory)threadFactory) : new NioEventLoopGroup(threads, (ThreadFactory)threadFactory);
    }

    public Client client() {
        return new NettyClient(this.eventLoopGroup);
    }

    public Server server() {
        return new NettyServer(this.eventLoopGroup);
    }
}

