/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.transport;

import io.atomix.catalyst.transport.Address;
import io.atomix.catalyst.transport.Connection;
import io.atomix.catalyst.transport.NettyConnection;
import io.atomix.catalyst.transport.NettyHandler;
import io.atomix.catalyst.transport.NettyTls;
import io.atomix.catalyst.transport.NettyTransport;
import io.atomix.catalyst.transport.Server;
import io.atomix.catalyst.util.Assert;
import io.atomix.catalyst.util.concurrent.ThreadContext;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.LengthFieldPrepender;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyServer
implements Server {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyServer.class);
    private static final ByteBufAllocator ALLOCATOR = new PooledByteBufAllocator(true);
    private static final ChannelHandler FIELD_PREPENDER = new LengthFieldPrepender(2);
    private final NettyTransport transport;
    private final Map<Channel, NettyConnection> connections = new ConcurrentHashMap<Channel, NettyConnection>();
    private ServerHandler handler;
    private ChannelGroup channelGroup;
    private NettyTls nettytls;
    private volatile boolean listening;
    private CompletableFuture<Void> listenFuture;

    public NettyServer(NettyTransport transport) {
        this.transport = (NettyTransport)Assert.notNull((Object)transport, (String)"transport");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> listen(Address address, Consumer<Connection> listener) {
        Assert.notNull((Object)address, (String)"address");
        Assert.notNull(listener, (String)"listener");
        if (this.listening) {
            return CompletableFuture.completedFuture(null);
        }
        ThreadContext context = ThreadContext.currentContextOrThrow();
        NettyServer nettyServer = this;
        synchronized (nettyServer) {
            if (this.listenFuture == null) {
                this.listenFuture = new CompletableFuture();
                this.listen(address, listener, context);
            }
        }
        return this.listenFuture;
    }

    private void listen(Address address, Consumer<Connection> listener, ThreadContext context) {
        this.channelGroup = new DefaultChannelGroup("catalyst-acceptor-channels", (EventExecutor)GlobalEventExecutor.INSTANCE);
        this.handler = new ServerHandler(this.connections, listener, context);
        ServerBootstrap bootstrap = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)bootstrap.group(this.transport.eventLoopGroup()).channel(NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(LogLevel.DEBUG))).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel channel) throws Exception {
                ChannelPipeline pipeline = channel.pipeline();
                if (NettyServer.this.transport.properties().sslEnabled()) {
                    pipeline.addFirst(new ChannelHandler[]{new SslHandler(new NettyTls(NettyServer.this.transport.properties()).initSslEngine(false))});
                }
                pipeline.addLast(new ChannelHandler[]{FIELD_PREPENDER});
                pipeline.addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(65536, 0, 2, 0, 2)});
                pipeline.addLast(new ChannelHandler[]{NettyServer.this.handler});
            }
        }).option(ChannelOption.SO_BACKLOG, (Object)this.transport.properties().acceptBacklog())).option(ChannelOption.TCP_NODELAY, (Object)this.transport.properties().tcpNoDelay())).option(ChannelOption.SO_REUSEADDR, (Object)this.transport.properties().reuseAddress())).childOption(ChannelOption.ALLOCATOR, (Object)ALLOCATOR).childOption(ChannelOption.SO_KEEPALIVE, (Object)this.transport.properties().tcpKeepAlive());
        if (this.transport.properties().sendBufferSize() != -1) {
            bootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)this.transport.properties().sendBufferSize());
        }
        if (this.transport.properties().receiveBufferSize() != -1) {
            bootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)this.transport.properties().receiveBufferSize());
        }
        LOGGER.info("Binding to {}", (Object)address);
        ChannelFuture bindFuture = bootstrap.bind((SocketAddress)address.socketAddress());
        bindFuture.addListener((GenericFutureListener)((ChannelFutureListener)channelFuture2 -> {
            if (channelFuture2.isSuccess()) {
                this.listening = true;
                context.executor().execute(() -> {
                    LOGGER.info("Listening at {}", (Object)bindFuture.channel().localAddress());
                    this.listenFuture.complete(null);
                });
            } else {
                context.execute(() -> this.listenFuture.completeExceptionally(channelFuture2.cause()));
            }
        }));
        this.channelGroup.add((Object)bindFuture.channel());
    }

    @Override
    public CompletableFuture<Void> close() {
        int i = 0;
        CompletableFuture[] futures = new CompletableFuture[this.connections.size()];
        for (Connection connection : this.connections.values()) {
            futures[i++] = connection.close();
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        CompletableFuture.allOf(futures).whenComplete((result, error) -> this.channelGroup.close().addListener(channelFuture -> future.complete(null)));
        return future;
    }

    @ChannelHandler.Sharable
    private static class ServerHandler
    extends NettyHandler {
        private ServerHandler(Map<Channel, NettyConnection> connections, Consumer<Connection> listener, ThreadContext context) {
            super(connections, listener, context);
        }
    }
}

