/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.serializer;

import io.atomix.catalyst.serializer.SerializableTypeResolver;
import io.atomix.catalyst.serializer.SerializerRegistry;
import io.atomix.catalyst.serializer.TypeSerializer;
import io.atomix.catalyst.serializer.collection.ListSerializer;
import io.atomix.catalyst.serializer.collection.MapSerializer;
import io.atomix.catalyst.serializer.collection.SetSerializer;
import io.atomix.catalyst.serializer.util.BigDecimalSerializer;
import io.atomix.catalyst.serializer.util.BigIntegerSerializer;
import io.atomix.catalyst.serializer.util.CalendarSerializer;
import io.atomix.catalyst.serializer.util.DateSerializer;
import io.atomix.catalyst.serializer.util.ExternalizableSerializer;
import io.atomix.catalyst.serializer.util.TimeZoneSerializer;
import java.io.Externalizable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

public class JdkTypeResolver
implements SerializableTypeResolver {
    private static final HashMap<Class<?>, Class<? extends TypeSerializer<?>>> SERIALIZERS = new LinkedHashMap(){
        {
            this.put(BigInteger.class, BigIntegerSerializer.class);
            this.put(BigDecimal.class, BigDecimalSerializer.class);
            this.put(Date.class, DateSerializer.class);
            this.put(Calendar.class, CalendarSerializer.class);
            this.put(TimeZone.class, TimeZoneSerializer.class);
            this.put(Map.class, MapSerializer.class);
            this.put(Set.class, SetSerializer.class);
            this.put(List.class, ListSerializer.class);
            this.put(Externalizable.class, ExternalizableSerializer.class);
        }
    };

    @Override
    public void resolve(SerializerRegistry registry) {
        int i = 176;
        for (Map.Entry<Class<?>, Class<TypeSerializer<?>>> entry : SERIALIZERS.entrySet()) {
            registry.register(entry.getKey(), entry.getValue(), i++);
        }
    }
}

