/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.serializer;

import io.atomix.catalyst.serializer.SerializableTypeResolver;
import io.atomix.catalyst.serializer.SerializerRegistry;
import io.atomix.catalyst.serializer.TypeSerializer;
import io.atomix.catalyst.serializer.lang.BooleanArraySerializer;
import io.atomix.catalyst.serializer.lang.BooleanSerializer;
import io.atomix.catalyst.serializer.lang.ByteArraySerializer;
import io.atomix.catalyst.serializer.lang.ByteSerializer;
import io.atomix.catalyst.serializer.lang.CharacterArraySerializer;
import io.atomix.catalyst.serializer.lang.CharacterSerializer;
import io.atomix.catalyst.serializer.lang.ClassSerializer;
import io.atomix.catalyst.serializer.lang.DoubleArraySerializer;
import io.atomix.catalyst.serializer.lang.DoubleSerializer;
import io.atomix.catalyst.serializer.lang.EnumSerializer;
import io.atomix.catalyst.serializer.lang.FloatArraySerializer;
import io.atomix.catalyst.serializer.lang.FloatSerializer;
import io.atomix.catalyst.serializer.lang.IntegerArraySerializer;
import io.atomix.catalyst.serializer.lang.IntegerSerializer;
import io.atomix.catalyst.serializer.lang.LongArraySerializer;
import io.atomix.catalyst.serializer.lang.LongSerializer;
import io.atomix.catalyst.serializer.lang.ShortArraySerializer;
import io.atomix.catalyst.serializer.lang.ShortSerializer;
import io.atomix.catalyst.serializer.lang.StringSerializer;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class PrimitiveTypeResolver
implements SerializableTypeResolver {
    private static final HashMap<Class<?>, Class<? extends TypeSerializer<?>>> SERIALIZERS = new LinkedHashMap(){
        {
            this.put(Byte.TYPE, ByteSerializer.class);
            this.put(Byte.class, ByteSerializer.class);
            this.put(byte[].class, ByteArraySerializer.class);
            this.put(Byte[].class, ByteArraySerializer.class);
            this.put(Boolean.TYPE, BooleanSerializer.class);
            this.put(Boolean.class, BooleanSerializer.class);
            this.put(boolean[].class, BooleanArraySerializer.class);
            this.put(Boolean[].class, BooleanArraySerializer.class);
            this.put(Character.TYPE, CharacterSerializer.class);
            this.put(Character.class, CharacterSerializer.class);
            this.put(char[].class, CharacterArraySerializer.class);
            this.put(Character[].class, CharacterArraySerializer.class);
            this.put(Short.TYPE, ShortSerializer.class);
            this.put(Short.class, ShortSerializer.class);
            this.put(short[].class, ShortArraySerializer.class);
            this.put(Short[].class, ShortArraySerializer.class);
            this.put(Integer.TYPE, IntegerSerializer.class);
            this.put(Integer.class, IntegerSerializer.class);
            this.put(int[].class, IntegerArraySerializer.class);
            this.put(Integer[].class, IntegerArraySerializer.class);
            this.put(Long.TYPE, LongSerializer.class);
            this.put(Long.class, LongSerializer.class);
            this.put(long[].class, LongArraySerializer.class);
            this.put(Long[].class, LongArraySerializer.class);
            this.put(Float.TYPE, FloatSerializer.class);
            this.put(Float.class, FloatSerializer.class);
            this.put(float[].class, FloatArraySerializer.class);
            this.put(Float[].class, FloatArraySerializer.class);
            this.put(Double.TYPE, DoubleSerializer.class);
            this.put(Double.class, DoubleSerializer.class);
            this.put(double[].class, DoubleArraySerializer.class);
            this.put(Double[].class, DoubleArraySerializer.class);
            this.put(String.class, StringSerializer.class);
            this.put(Class.class, ClassSerializer.class);
            this.put(Enum.class, EnumSerializer.class);
        }
    };

    @Override
    public void resolve(SerializerRegistry registry) {
        int i = 128;
        for (Map.Entry<Class<?>, Class<TypeSerializer<?>>> entry : SERIALIZERS.entrySet()) {
            registry.register(entry.getKey(), entry.getValue(), i++);
        }
    }
}

