/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.serializer;

import io.atomix.catalyst.buffer.Buffer;
import io.atomix.catalyst.buffer.BufferAllocator;
import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.buffer.InputStreamBufferInput;
import io.atomix.catalyst.buffer.OutputStreamBufferOutput;
import io.atomix.catalyst.buffer.UnpooledHeapAllocator;
import io.atomix.catalyst.serializer.SerializableTypeResolver;
import io.atomix.catalyst.serializer.SerializationException;
import io.atomix.catalyst.serializer.SerializerRegistry;
import io.atomix.catalyst.serializer.TypeSerializer;
import io.atomix.catalyst.serializer.TypeSerializerFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Serializer
implements Cloneable {
    private static final int MAX_ID_8 = 255;
    private static final int MAX_ID_16 = 65535;
    private static final int MAX_ID_24 = 0xFFFFFF;
    private static final byte TYPE_NULL = 0;
    private static final byte TYPE_BUFFER = 1;
    private static final byte TYPE_ID_8 = 2;
    private static final byte TYPE_ID_16 = 3;
    private static final byte TYPE_ID_24 = 4;
    private static final byte TYPE_ID_32 = 5;
    private static final byte TYPE_CLASS = 7;
    private static final byte TYPE_SERIALIZABLE = 8;
    private SerializerRegistry registry;
    private Map<Class<?>, TypeSerializer<?>> serializers = new HashMap();
    private Map<String, Class<?>> types = new HashMap();
    private final BufferAllocator allocator;

    public Serializer() {
        this((BufferAllocator)new UnpooledHeapAllocator(), new SerializableTypeResolver[0]);
    }

    public Serializer(BufferAllocator allocator) {
        this(allocator, new SerializableTypeResolver[0]);
    }

    public Serializer(SerializableTypeResolver ... resolvers) {
        this((BufferAllocator)new UnpooledHeapAllocator(), resolvers);
    }

    public Serializer(Collection<SerializableTypeResolver> resolvers) {
        this((BufferAllocator)new UnpooledHeapAllocator(), resolvers);
    }

    public Serializer(BufferAllocator allocator, SerializableTypeResolver ... resolvers) {
        this(allocator, resolvers != null ? Arrays.asList(resolvers) : Collections.EMPTY_LIST);
    }

    public Serializer(BufferAllocator allocator, Collection<SerializableTypeResolver> resolvers) {
        if (allocator == null) {
            throw new NullPointerException("allocator cannot be null");
        }
        this.allocator = allocator;
        this.registry = new SerializerRegistry(resolvers);
    }

    public Serializer resolve(SerializableTypeResolver ... resolvers) {
        this.registry.resolve(resolvers);
        return this;
    }

    public Serializer resolve(Collection<SerializableTypeResolver> resolvers) {
        this.registry.resolve(resolvers);
        return this;
    }

    public Serializer register(Class<?> type) {
        this.registry.register(type);
        return this;
    }

    public Serializer register(Class<?> type, int id) {
        this.registry.register(type, id);
        return this;
    }

    public Serializer register(Class<?> type, Class<? extends TypeSerializer<?>> serializer) {
        this.registry.register(type, serializer);
        return this;
    }

    public Serializer register(Class<?> type, TypeSerializerFactory factory) {
        this.registry.register(type, factory);
        return this;
    }

    public Serializer register(Class<?> type, Class<? extends TypeSerializer<?>> serializer, int id) {
        this.registry.register(type, serializer, id);
        return this;
    }

    public Serializer register(Class<?> type, TypeSerializerFactory factory, int id) {
        this.registry.register(type, factory, id);
        return this;
    }

    public BufferAllocator allocator() {
        return this.allocator;
    }

    public Buffer allocate() {
        return this.allocator.allocate();
    }

    public Buffer allocate(long capacity) {
        return this.allocator.allocate(capacity);
    }

    public Buffer allocate(long initialCapacity, long maxCapacity) {
        return this.allocator.allocate(initialCapacity, maxCapacity);
    }

    public <T> T copy(T object) {
        return this.readObject(this.writeObject(object).flip());
    }

    private <T> TypeSerializer<T> getSerializer(Class<T> type) {
        TypeSerializerFactory factory;
        TypeSerializer<?> serializer = this.serializers.get(type);
        if (serializer == null && (factory = this.registry.lookup(type)) != null) {
            serializer = factory.createSerializer(type);
            this.serializers.put(type, serializer);
        }
        return serializer;
    }

    public <T> Buffer writeObject(T object) {
        return this.writeObject(object, this.allocator.allocate());
    }

    public <T> OutputStream writeObject(T object, OutputStream outputStream) {
        this.writeObject(object, (BufferOutput<?>)new OutputStreamBufferOutput(outputStream));
        return outputStream;
    }

    public <T> Buffer writeObject(T object, Buffer buffer) {
        this.writeObject(object, (BufferOutput<?>)buffer);
        return buffer;
    }

    public <T> BufferOutput<?> writeObject(T object, BufferOutput<?> buffer) {
        if (object == null) {
            return this.writeNull(buffer);
        }
        if (object instanceof Buffer) {
            return this.writeBuffer((Buffer)object, buffer);
        }
        Class<?> type = object.getClass();
        Integer typeId = this.registry.ids().get(type);
        if (typeId != null) {
            TypeSerializer<?> serializer = this.getSerializer(type);
            if (serializer == null) {
                if (object instanceof Serializable) {
                    return this.writeSerializable(object, buffer);
                }
                throw new SerializationException("cannot serialize unregistered type: " + type);
            }
            if (typeId >= 0) {
                if (typeId <= 255) {
                    return this.writeById8(typeId, object, buffer, serializer);
                }
                if (typeId <= 65535) {
                    return this.writeById16(typeId, object, buffer, serializer);
                }
                if (typeId <= 0xFFFFFF) {
                    return this.writeById24(typeId, object, buffer, serializer);
                }
            }
            return this.writeById32(typeId, object, buffer, serializer);
        }
        TypeSerializer<?> serializer = this.getSerializer(type);
        if (serializer == null) {
            if (object instanceof Serializable) {
                return this.writeSerializable(object, buffer);
            }
            throw new SerializationException("cannot serialize unregistered type: " + type);
        }
        return this.writeByClass(type, object, buffer, serializer);
    }

    private BufferOutput<?> writeNull(BufferOutput<?> buffer) {
        return buffer.writeByte(0);
    }

    private BufferOutput<?> writeBuffer(Buffer object, BufferOutput<?> buffer) {
        return buffer.writeByte(1).write(object);
    }

    private <T> BufferOutput<?> writeById8(int id, T object, BufferOutput<?> buffer, TypeSerializer serializer) {
        serializer.write(object, buffer.writeByte(2).writeUnsignedByte(id), this);
        return buffer;
    }

    private <T> BufferOutput<?> writeById16(int id, T object, BufferOutput<?> buffer, TypeSerializer serializer) {
        serializer.write(object, buffer.writeByte(3).writeUnsignedShort(id), this);
        return buffer;
    }

    private <T> BufferOutput<?> writeById24(int id, T object, BufferOutput<?> buffer, TypeSerializer serializer) {
        serializer.write(object, buffer.writeByte(4).writeUnsignedMedium(id), this);
        return buffer;
    }

    private <T> BufferOutput<?> writeById32(int id, T object, BufferOutput<?> buffer, TypeSerializer serializer) {
        serializer.write(object, buffer.writeByte(5).writeInt(id), this);
        return buffer;
    }

    private <T> BufferOutput<?> writeByClass(Class<?> type, T object, BufferOutput<?> buffer, TypeSerializer serializer) {
        serializer.write(object, buffer.writeByte(7).writeUTF8(type.getName()), this);
        return buffer;
    }

    private <T> BufferOutput<?> writeSerializable(T serializable, BufferOutput<?> buffer) {
        buffer.writeByte(8);
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();
             ObjectOutputStream out = new ObjectOutputStream(os);){
            out.writeObject(serializable);
            out.flush();
            byte[] bytes = os.toByteArray();
            buffer.writeUnsignedShort(bytes.length).write(bytes);
        }
        catch (IOException e) {
            throw new SerializationException("failed to serialize Java object", e);
        }
        return buffer;
    }

    public <T> T readObject(InputStream inputStream) {
        return this.readObject((BufferInput<?>)new InputStreamBufferInput(inputStream));
    }

    public <T> T readObject(Buffer buffer) {
        return this.readObject((BufferInput<?>)buffer);
    }

    public <T> T readObject(BufferInput<?> buffer) {
        int type = buffer.readByte();
        switch (type) {
            case 0: {
                return null;
            }
            case 1: {
                return (T)this.readBuffer(buffer);
            }
            case 2: {
                return this.readById8(buffer);
            }
            case 3: {
                return this.readById16(buffer);
            }
            case 4: {
                return this.readById24(buffer);
            }
            case 5: {
                return this.readById32(buffer);
            }
            case 7: {
                return this.readByClass(buffer);
            }
            case 8: {
                return this.readSerializable(buffer);
            }
        }
        throw new SerializationException("unknown serializable type");
    }

    private Buffer readBuffer(BufferInput<?> buffer) {
        Buffer object = this.allocator.allocate();
        buffer.read(object);
        return object;
    }

    private <T> T readById8(BufferInput<?> buffer) {
        int id = buffer.readUnsignedByte();
        Class<?> type = this.registry.types().get(id);
        TypeSerializer<?> serializer = this.getSerializer(type);
        if (type == null || serializer == null) {
            throw new SerializationException("cannot deserialize: unknown type");
        }
        return (T)serializer.read(type, buffer, this);
    }

    private <T> T readById16(BufferInput<?> buffer) {
        int id = buffer.readUnsignedShort();
        Class<?> type = this.registry.types().get(id);
        TypeSerializer<?> serializer = this.getSerializer(type);
        if (type == null || serializer == null) {
            throw new SerializationException("cannot deserialize: unknown type");
        }
        return (T)serializer.read(type, buffer, this);
    }

    private <T> T readById24(BufferInput<?> buffer) {
        int id = buffer.readUnsignedMedium();
        Class<?> type = this.registry.types().get(id);
        TypeSerializer<?> serializer = this.getSerializer(type);
        if (type == null || serializer == null) {
            throw new SerializationException("cannot deserialize: unknown type");
        }
        return (T)serializer.read(type, buffer, this);
    }

    private <T> T readById32(BufferInput<?> buffer) {
        int id = buffer.readInt();
        Class<?> type = this.registry.types().get(id);
        TypeSerializer<?> serializer = this.getSerializer(type);
        if (type == null || serializer == null) {
            throw new SerializationException("cannot deserialize: unknown type");
        }
        return (T)serializer.read(type, buffer, this);
    }

    private <T> T readByClass(BufferInput<?> buffer) {
        TypeSerializer<?> serializer;
        String name = buffer.readUTF8();
        Class<?> type = this.types.get(name);
        if (type == null) {
            try {
                type = Class.forName(name);
                if (type == null) {
                    throw new SerializationException("cannot deserialize: unknown type");
                }
                this.types.put(name, type);
            }
            catch (ClassNotFoundException e) {
                throw new SerializationException("object class not found: " + name, e);
            }
        }
        if ((serializer = this.getSerializer(type)) == null) {
            throw new SerializationException("cannot deserialize: unknown type");
        }
        return (T)serializer.read(type, buffer, this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T readSerializable(BufferInput<?> buffer) {
        byte[] bytes = new byte[buffer.readUnsignedShort()];
        buffer.read(bytes);
        try {
            Throwable throwable = null;
            try (ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));){
                Object object = in.readObject();
                return (T)object;
            }
            catch (ClassNotFoundException e) {
                try {
                    throw new SerializationException("failed to deserialize Java object", e);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
        catch (IOException e) {
            throw new SerializationException("failed to deserialize Java object", e);
        }
    }

    public final Serializer clone() {
        try {
            Serializer serializer = (Serializer)super.clone();
            serializer.registry = this.registry.clone();
            serializer.serializers = new HashMap();
            serializer.types = new HashMap(this.types);
            return serializer;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

