/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.serializer;

import io.atomix.catalyst.CatalystException;
import io.atomix.catalyst.serializer.CatalystSerializable;
import io.atomix.catalyst.serializer.CatalystSerializableSerializer;
import io.atomix.catalyst.serializer.DefaultTypeSerializerFactory;
import io.atomix.catalyst.serializer.JdkTypeResolver;
import io.atomix.catalyst.serializer.PrimitiveTypeResolver;
import io.atomix.catalyst.serializer.RegistrationException;
import io.atomix.catalyst.serializer.SerializableTypeResolver;
import io.atomix.catalyst.serializer.SerializeWith;
import io.atomix.catalyst.serializer.TypeSerializer;
import io.atomix.catalyst.serializer.TypeSerializerFactory;
import io.atomix.catalyst.serializer.util.ExternalizableSerializer;
import io.atomix.catalyst.util.Hash;
import java.io.Externalizable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SerializerRegistry
implements Cloneable {
    private static final SerializableTypeResolver PRIMITIVE_RESOLVER = new PrimitiveTypeResolver();
    private static final SerializableTypeResolver JDK_RESOLVER = new JdkTypeResolver();
    private Map<Class<?>, TypeSerializerFactory> factories;
    private Map<Class<?>, Integer> ids;
    private Map<Integer, Class<?>> types;

    public SerializerRegistry() {
        this(Collections.EMPTY_LIST);
    }

    public SerializerRegistry(SerializableTypeResolver ... resolvers) {
        this(Arrays.asList(resolvers));
    }

    public SerializerRegistry(Collection<SerializableTypeResolver> resolvers) {
        this(new HashMap(), new HashMap(), new HashMap());
        PRIMITIVE_RESOLVER.resolve(this);
        JDK_RESOLVER.resolve(this);
        this.resolve(resolvers);
    }

    private SerializerRegistry(Map<Class<?>, TypeSerializerFactory> factories, Map<Class<?>, Integer> ids, Map<Integer, Class<?>> types) {
        this.factories = factories;
        this.ids = ids;
        this.types = types;
    }

    public SerializerRegistry resolve(SerializableTypeResolver ... resolvers) {
        return this.resolve(resolvers != null ? Arrays.asList(resolvers) : Collections.EMPTY_LIST);
    }

    public SerializerRegistry resolve(Collection<SerializableTypeResolver> resolvers) {
        if (resolvers != null) {
            for (SerializableTypeResolver resolver : resolvers) {
                resolver.resolve(this);
            }
        }
        return this;
    }

    SerializerRegistry copy() {
        return new SerializerRegistry(new HashMap(this.factories), new HashMap(this.ids), new HashMap(this.types));
    }

    private int findTypeId(Class<?> type) {
        if (type == null) {
            throw new NullPointerException("type cannot be null");
        }
        SerializeWith serializeWith = type.getAnnotation(SerializeWith.class);
        if (serializeWith != null) {
            int id = serializeWith.id();
            if (id == -1) {
                return Hash.hash32(type.getName());
            }
            return id;
        }
        return Hash.hash32(type.getName());
    }

    public SerializerRegistry register(Class<?> type) {
        if (type == null) {
            throw new NullPointerException("type cannot be null");
        }
        return this.register(type, this.findTypeId(type));
    }

    public SerializerRegistry register(Class<?> type, int id) {
        if (type == null) {
            throw new NullPointerException("type cannot be null");
        }
        SerializeWith serializeWith = type.getAnnotation(SerializeWith.class);
        if (serializeWith != null && serializeWith.serializer() != null) {
            return this.register(type, new DefaultTypeSerializerFactory(serializeWith.serializer()), id);
        }
        if (CatalystSerializable.class.isAssignableFrom(type)) {
            return this.register(type, new DefaultTypeSerializerFactory(CatalystSerializableSerializer.class), id);
        }
        if (Externalizable.class.isAssignableFrom(type)) {
            return this.register(type, new DefaultTypeSerializerFactory(ExternalizableSerializer.class), id);
        }
        throw new CatalystException("failed to register serializable type: " + type);
    }

    public SerializerRegistry register(Class<?> type, Class<? extends TypeSerializer> serializer) {
        return this.register(type, new DefaultTypeSerializerFactory(serializer), this.findTypeId(type));
    }

    public SerializerRegistry register(Class<?> type, TypeSerializerFactory factory) {
        return this.register(type, factory, this.findTypeId(type));
    }

    public SerializerRegistry register(Class<?> type, Class<? extends TypeSerializer> serializer, int id) {
        return this.register(type, new DefaultTypeSerializerFactory(serializer), id);
    }

    public SerializerRegistry register(Class<?> type, TypeSerializerFactory factory, int id) {
        if (type == null) {
            throw new NullPointerException("type cannot be null");
        }
        if (this.types.containsKey(id) && this.types.get(id) != type) {
            throw new RegistrationException("serializable type ID already registered: " + id);
        }
        if (this.ids.containsKey(type)) {
            if (this.ids.get(type) != id) {
                throw new RegistrationException("type registered with a different ID: " + type);
            }
            return this;
        }
        this.factories.put(type, factory);
        this.types.put(id, type);
        this.ids.put(type, id);
        return this;
    }

    public TypeSerializerFactory lookup(Class<?> type) {
        TypeSerializerFactory factory = this.factories.get(type);
        if (factory == null) {
            for (Map.Entry<Class<?>, TypeSerializerFactory> entry : this.factories.entrySet()) {
                if (!entry.getKey().isAssignableFrom(type)) continue;
                factory = entry.getValue();
                break;
            }
            if (factory != null) {
                this.factories.put(type, factory);
            } else {
                this.factories.put(type, null);
            }
        }
        return factory;
    }

    Map<Class<?>, Integer> ids() {
        return this.ids;
    }

    Map<Integer, Class<?>> types() {
        return this.types;
    }

    public final SerializerRegistry clone() {
        try {
            SerializerRegistry clone = (SerializerRegistry)super.clone();
            clone.ids = new HashMap(this.ids);
            clone.factories = new HashMap(this.factories);
            clone.types = new HashMap(this.types);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

