/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.serializer;

import io.atomix.catalyst.CatalystException;
import io.atomix.catalyst.serializer.CatalystSerializable;
import io.atomix.catalyst.serializer.SerializableTypeResolver;
import io.atomix.catalyst.serializer.Serialize;
import io.atomix.catalyst.serializer.SerializeWith;
import io.atomix.catalyst.serializer.SerializerRegistry;
import io.atomix.catalyst.serializer.TypeSerializer;
import io.atomix.catalyst.serializer.TypeSerializerFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class ServiceLoaderTypeResolver
implements SerializableTypeResolver {
    @Override
    public void resolve(SerializerRegistry registry) {
        this.resolveFactories(registry);
        this.resolveSerializers(registry);
        this.resolveSerializables(registry);
    }

    private <T> List<Class<? extends T>> load(Class<T> clazz) {
        Enumeration<URL> urls;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        try {
            urls = cl.getResources(String.format("META-INF/services/%s", clazz.getName()));
        }
        catch (IOException e) {
            throw new CatalystException((Throwable)e);
        }
        ArrayList<Class<T>> classes = new ArrayList<Class<T>>();
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            try {
                String line;
                InputStream is = url.openStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                while ((line = reader.readLine()) != null) {
                    int comment = line.lastIndexOf(35);
                    if (comment >= 0) {
                        line = line.substring(0, line.lastIndexOf(35));
                    }
                    if ((line = line.trim()).length() <= 0) continue;
                    try {
                        classes.add(cl.loadClass(line));
                    }
                    catch (ClassNotFoundException e) {
                        throw new CatalystException("failed to load class: " + line, (Throwable)e);
                    }
                }
                is.close();
            }
            catch (IOException | IllegalArgumentException | SecurityException e) {
                throw new CatalystException("failed to read services", (Throwable)e);
            }
        }
        return classes;
    }

    private void resolveFactories(SerializerRegistry registry) {
        for (Class<TypeSerializerFactory> factory : this.load(TypeSerializerFactory.class)) {
            Serialize serialize = factory.getAnnotation(Serialize.class);
            if (serialize == null) continue;
            for (Serialize.Type serializeType : serialize.value()) {
                if (serializeType.id() != -1) {
                    try {
                        registry.register(serializeType.type(), factory.newInstance(), serializeType.id());
                        continue;
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        throw new CatalystException("failed to instantiate serializer factory: " + factory, (Throwable)e);
                    }
                }
                try {
                    registry.register(serializeType.type(), factory.newInstance());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new CatalystException("failed to instantiate serializer factory: " + factory, (Throwable)e);
                }
            }
        }
    }

    private void resolveSerializers(SerializerRegistry registry) {
        for (Class<TypeSerializer> serializer : this.load(TypeSerializer.class)) {
            Serialize serialize = serializer.getAnnotation(Serialize.class);
            if (serialize == null) continue;
            for (Serialize.Type serializeType : serialize.value()) {
                if (serializeType.id() != -1) {
                    registry.register(serializeType.type(), serializer, serializeType.id());
                    continue;
                }
                registry.register(serializeType.type(), serializer);
            }
        }
    }

    private void resolveSerializables(SerializerRegistry registry) {
        for (Class<CatalystSerializable> serializable : this.load(CatalystSerializable.class)) {
            SerializeWith serializeWith = serializable.getAnnotation(SerializeWith.class);
            if (serializeWith != null) {
                if (serializeWith.serializer() != null && serializeWith.id() != -1) {
                    registry.register(serializable, serializeWith.serializer(), serializeWith.id());
                    continue;
                }
                if (serializeWith.serializer() != null) {
                    registry.register(serializable, serializeWith.serializer());
                    continue;
                }
                if (serializeWith.id() != -1) {
                    registry.register(serializable, serializeWith.id());
                    continue;
                }
                registry.register(serializable);
                continue;
            }
            registry.register(serializable);
        }
    }
}

