/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.serializer.collection;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.serializer.TypeSerializer;
import java.util.ArrayList;
import java.util.List;

public class ListSerializer
implements TypeSerializer<List<?>> {
    @Override
    public void write(List<?> object, BufferOutput<?> buffer, Serializer serializer) {
        buffer.writeUnsignedShort(object.size());
        for (Object value : object) {
            serializer.writeObject(value, buffer);
        }
    }

    @Override
    public List<?> read(Class<List<?>> type, BufferInput<?> buffer, Serializer serializer) {
        int size = buffer.readUnsignedShort();
        ArrayList object = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            object.add(serializer.readObject(buffer));
        }
        return object;
    }
}

