/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.serializer.collection;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.serializer.TypeSerializer;
import java.util.HashMap;
import java.util.Map;

public class MapSerializer
implements TypeSerializer<Map<?, ?>> {
    @Override
    public void write(Map<?, ?> object, BufferOutput<?> buffer, Serializer serializer) {
        buffer.writeUnsignedShort(object.size());
        for (Map.Entry<?, ?> entry : object.entrySet()) {
            serializer.writeObject(entry.getKey(), buffer);
            serializer.writeObject(entry.getValue(), buffer);
        }
    }

    @Override
    public Map<?, ?> read(Class<Map<?, ?>> type, BufferInput<?> buffer, Serializer serializer) {
        int size = buffer.readUnsignedShort();
        HashMap object = new HashMap(size);
        for (int i = 0; i < size; ++i) {
            Object key = serializer.readObject(buffer);
            Object value = serializer.readObject(buffer);
            object.put(key, value);
        }
        return object;
    }
}

