/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.serializer.collection;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.serializer.TypeSerializer;
import java.util.HashSet;
import java.util.Set;

public class SetSerializer
implements TypeSerializer<Set<?>> {
    @Override
    public void write(Set<?> object, BufferOutput<?> buffer, Serializer serializer) {
        buffer.writeUnsignedShort(object.size());
        for (Object value : object) {
            serializer.writeObject(value, buffer);
        }
    }

    @Override
    public Set<?> read(Class<Set<?>> type, BufferInput<?> buffer, Serializer serializer) {
        int size = buffer.readUnsignedShort();
        HashSet object = new HashSet(size);
        for (int i = 0; i < size; ++i) {
            object.add(serializer.readObject(buffer));
        }
        return object;
    }
}

