/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.serializer.lang;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.serializer.TypeSerializer;

public class BooleanArraySerializer
implements TypeSerializer<boolean[]> {
    @Override
    public void write(boolean[] chars, BufferOutput<?> buffer, Serializer serializer) {
        buffer.writeUnsignedShort(chars.length);
        for (boolean b : chars) {
            buffer.writeBoolean(b);
        }
    }

    @Override
    public boolean[] read(Class<boolean[]> type, BufferInput<?> buffer, Serializer serializer) {
        boolean[] booleans = new boolean[buffer.readUnsignedShort()];
        for (int i = 0; i < booleans.length; ++i) {
            booleans[i] = buffer.readBoolean();
        }
        return booleans;
    }
}

