/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.serializer.lang;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.serializer.TypeSerializer;

public class CharacterArraySerializer
implements TypeSerializer<char[]> {
    @Override
    public void write(char[] chars, BufferOutput<?> buffer, Serializer serializer) {
        buffer.writeUnsignedShort(chars.length);
        for (char c : chars) {
            buffer.writeChar(c);
        }
    }

    @Override
    public char[] read(Class<char[]> type, BufferInput<?> buffer, Serializer serializer) {
        char[] chars = new char[buffer.readUnsignedShort()];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = buffer.readChar();
        }
        return chars;
    }
}

