/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.serializer.lang;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.serializer.TypeSerializer;

public class LongArraySerializer
implements TypeSerializer<long[]> {
    @Override
    public void write(long[] longs, BufferOutput<?> buffer, Serializer serializer) {
        buffer.writeUnsignedShort(longs.length);
        for (long l : longs) {
            buffer.writeLong(l);
        }
    }

    @Override
    public long[] read(Class<long[]> type, BufferInput<?> buffer, Serializer serializer) {
        long[] longs = new long[buffer.readUnsignedShort()];
        for (int i = 0; i < longs.length; ++i) {
            longs[i] = buffer.readLong();
        }
        return longs;
    }
}

