/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.serializer.util;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.serializer.TypeSerializer;
import java.util.Calendar;
import java.util.TimeZone;

public class CalendarSerializer
implements TypeSerializer<Calendar> {
    @Override
    public void write(Calendar calendar, BufferOutput<?> buffer, Serializer serializer) {
        buffer.writeUTF8(calendar.getTimeZone().getID());
        buffer.writeLong(calendar.getTimeInMillis());
    }

    @Override
    public Calendar read(Class<Calendar> type, BufferInput<?> buffer, Serializer serializer) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone(buffer.readUTF8()));
        calendar.setTimeInMillis(buffer.readLong());
        return calendar;
    }
}

