/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.buffer;

import io.atomix.catalyst.buffer.Buffer;
import io.atomix.catalyst.buffer.BufferPool;
import io.atomix.catalyst.buffer.DirectBuffer;
import io.atomix.catalyst.buffer.DirectBytes;
import io.atomix.catalyst.util.ReferenceFactory;
import io.atomix.catalyst.util.ReferenceManager;

public class DirectBufferPool
extends BufferPool {
    public DirectBufferPool() {
        super(new DirectBufferFactory());
    }

    @Override
    public void release(Buffer reference) {
        reference.rewind();
        super.release(reference);
    }

    private static class DirectBufferFactory
    implements ReferenceFactory<Buffer> {
        private DirectBufferFactory() {
        }

        @Override
        public Buffer createReference(ReferenceManager<Buffer> manager) {
            DirectBuffer buffer = new DirectBuffer(DirectBytes.allocate(1024L), manager);
            buffer.reset(0L, 1024L, Long.MAX_VALUE);
            return buffer;
        }
    }
}

