/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.serializer;

import io.atomix.catalyst.serializer.DefaultTypeSerializerFactory;
import io.atomix.catalyst.serializer.RegistrationException;
import io.atomix.catalyst.serializer.SerializableTypeResolver;
import io.atomix.catalyst.serializer.TypeSerializer;
import io.atomix.catalyst.serializer.TypeSerializerFactory;
import io.atomix.catalyst.util.hash.Hasher;
import io.atomix.catalyst.util.hash.StringHasher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class SerializerRegistry {
    private final Hasher hasher = new StringHasher();
    private final Map<Class<?>, TypeSerializerFactory> factories = new ConcurrentHashMap();
    private final Map<Class<?>, TypeSerializerFactory> abstractFactories = Collections.synchronizedMap(new LinkedHashMap(1024, 0.75f, true));
    private final Map<Class<?>, TypeSerializerFactory> defaultFactories = Collections.synchronizedMap(new LinkedHashMap(1024, 0.75f, true));
    private final Map<Class<?>, Integer> ids = new ConcurrentHashMap();
    private final Map<Integer, Class<?>> types = new ConcurrentHashMap();

    public SerializerRegistry() {
        this(Collections.EMPTY_LIST);
    }

    public SerializerRegistry(SerializableTypeResolver ... resolvers) {
        this(Arrays.asList(resolvers));
    }

    public SerializerRegistry(Collection<SerializableTypeResolver> resolvers) {
        this.resolve(resolvers);
    }

    public SerializerRegistry resolve(SerializableTypeResolver ... resolvers) {
        return this.resolve(resolvers != null ? Arrays.asList(resolvers) : Collections.EMPTY_LIST);
    }

    public SerializerRegistry resolve(Collection<SerializableTypeResolver> resolvers) {
        if (resolvers != null) {
            for (SerializableTypeResolver resolver : resolvers) {
                resolver.resolve(this);
            }
        }
        return this;
    }

    private int calculateTypeId(Class<?> type) {
        if (type == null) {
            throw new NullPointerException("type cannot be null");
        }
        return this.hasher.hash32(type.getName());
    }

    public SerializerRegistry register(Class<?> type) {
        if (type == null) {
            throw new NullPointerException("type cannot be null");
        }
        return this.register(type, this.calculateTypeId(type));
    }

    public synchronized SerializerRegistry register(Class<?> type, int id) {
        if (type == null) {
            throw new NullPointerException("type cannot be null");
        }
        Class<?> baseType = this.findBaseType(type, this.defaultFactories);
        if (baseType == null) {
            throw new RegistrationException("no default serializer found for type: " + type);
        }
        return this.register(type, id, this.defaultFactories.get(baseType));
    }

    public SerializerRegistry register(Class<?> type, Class<? extends TypeSerializer> serializer) {
        return this.register(type, this.calculateTypeId(type), new DefaultTypeSerializerFactory(serializer));
    }

    public SerializerRegistry register(Class<?> type, TypeSerializerFactory factory) {
        return this.register(type, this.calculateTypeId(type), factory);
    }

    public SerializerRegistry register(Class<?> type, int id, Class<? extends TypeSerializer> serializer) {
        return this.register(type, id, new DefaultTypeSerializerFactory(serializer));
    }

    public synchronized SerializerRegistry register(Class<?> type, int id, TypeSerializerFactory factory) {
        if (type == null) {
            throw new NullPointerException("type cannot be null");
        }
        if (this.types.containsKey(id) && this.types.get(id) != type) {
            throw new RegistrationException("serializable type ID already registered: " + id);
        }
        if (this.ids.containsKey(type)) {
            if (this.ids.get(type) != id) {
                throw new RegistrationException("type registered with a different ID: " + type);
            }
            return this;
        }
        this.factories.put(type, factory);
        this.types.put(id, type);
        this.ids.put(type, id);
        return this;
    }

    public SerializerRegistry registerAbstract(Class<?> abstractType, Class<? extends TypeSerializer> serializer) {
        return this.registerAbstract(abstractType, this.calculateTypeId(abstractType), new DefaultTypeSerializerFactory(serializer));
    }

    public SerializerRegistry registerAbstract(Class<?> abstractType, TypeSerializerFactory factory) {
        return this.registerAbstract(abstractType, this.calculateTypeId(abstractType), factory);
    }

    public SerializerRegistry registerAbstract(Class<?> abstractType, int id, Class<? extends TypeSerializer> serializer) {
        return this.registerAbstract(abstractType, id, new DefaultTypeSerializerFactory(serializer));
    }

    public SerializerRegistry registerAbstract(Class<?> abstractType, int id, TypeSerializerFactory factory) {
        this.abstractFactories.put(abstractType, factory);
        this.types.put(id, abstractType);
        this.ids.put(abstractType, id);
        return this;
    }

    public SerializerRegistry registerDefault(Class<?> baseType, Class<? extends TypeSerializer> serializer) {
        return this.registerDefault(baseType, new DefaultTypeSerializerFactory(serializer));
    }

    public synchronized SerializerRegistry registerDefault(Class<?> baseType, TypeSerializerFactory factory) {
        this.defaultFactories.put(baseType, factory);
        return this;
    }

    private Class<?> findBaseType(Class<?> type, Map<Class<?>, TypeSerializerFactory> factories) {
        if (factories.containsKey(type)) {
            return type;
        }
        ArrayList orderedFactories = new ArrayList(factories.entrySet());
        Collections.reverse(orderedFactories);
        Optional<Map.Entry> optional = orderedFactories.stream().filter(e -> ((Class)e.getKey()).isAssignableFrom(type)).findFirst();
        return optional.isPresent() ? (Class)optional.get().getKey() : null;
    }

    synchronized TypeSerializerFactory factory(Class<?> type) {
        TypeSerializerFactory factory = this.factories.get(type);
        if (factory != null) {
            return factory;
        }
        Class<?> baseType = this.findBaseType(type, this.abstractFactories);
        if (baseType != null) {
            return this.abstractFactories.get(baseType);
        }
        baseType = this.findBaseType(type, this.defaultFactories);
        if (baseType != null) {
            return this.defaultFactories.get(baseType);
        }
        return null;
    }

    synchronized int id(Class<?> type) {
        Integer id = this.ids.get(type);
        if (id != null) {
            return id;
        }
        Class<?> baseType = this.findBaseType(type, this.abstractFactories);
        if (baseType != null && (id = this.ids.get(baseType)) != null) {
            return id;
        }
        return 0;
    }

    Class<?> type(int id) {
        return this.types.get(id);
    }
}

