/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.serializer.util;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.serializer.TypeSerializer;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;

public class BigIntegerSerializer
implements TypeSerializer<BigInteger> {
    @Override
    public void write(BigInteger object, BufferOutput buffer, Serializer serializer) {
        byte[] bytes = object.toString().getBytes(StandardCharsets.UTF_8);
        buffer.writeInt(bytes.length).write(bytes);
    }

    @Override
    public BigInteger read(Class<BigInteger> type, BufferInput buffer, Serializer serializer) {
        byte[] bytes = new byte[buffer.readInt()];
        buffer.read(bytes);
        return new BigInteger(new String(bytes, StandardCharsets.UTF_8));
    }
}

