/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.util.hash;

import io.atomix.catalyst.util.hash.Hasher;

public class Murmur2Hasher
implements Hasher {
    private final int seed;

    public Murmur2Hasher() {
        this.seed = -1756908916;
    }

    public Murmur2Hasher(int seed) {
        this.seed = seed;
    }

    @Override
    public int hash32(byte[] bytes) {
        int m = 1540483477;
        int r = 24;
        int length = bytes.length;
        int length4 = bytes.length / 4;
        int h = this.seed ^ length;
        for (int i = 0; i < length4; ++i) {
            int i4 = i * 4;
            int k = (bytes[i4] & 0xFF) + ((bytes[i4 + 1] & 0xFF) << 8) + ((bytes[i4 + 2] & 0xFF) << 16) + ((bytes[i4 + 3] & 0xFF) << 24);
            k *= 1540483477;
            k ^= k >>> 24;
            h *= 1540483477;
            h ^= (k *= 1540483477);
        }
        switch (length % 4) {
            case 3: {
                h ^= (bytes[(length & 0xFFFFFFFC) + 2] & 0xFF) << 16;
            }
            case 2: {
                h ^= (bytes[(length & 0xFFFFFFFC) + 1] & 0xFF) << 8;
            }
            case 1: {
                h ^= bytes[length & 0xFFFFFFFC] & 0xFF;
                h *= 1540483477;
            }
        }
        h ^= h >>> 13;
        h *= 1540483477;
        h ^= h >>> 15;
        return h;
    }

    @Override
    public long hash64(byte[] bytes) {
        long m = -4132994306676758123L;
        int r = 47;
        int length = bytes.length;
        int length8 = bytes.length / 8;
        long h = (long)this.seed & 0xFFFFFFFFL ^ (long)length * -4132994306676758123L;
        for (int i = 0; i < length8; ++i) {
            int i8 = i * 8;
            long k = ((long)bytes[i8] & 0xFFL) + (((long)bytes[i8 + 1] & 0xFFL) << 8) + (((long)bytes[i8 + 2] & 0xFFL) << 16) + (((long)bytes[i8 + 3] & 0xFFL) << 24) + (((long)bytes[i8 + 4] & 0xFFL) << 32) + (((long)bytes[i8 + 5] & 0xFFL) << 40) + (((long)bytes[i8 + 6] & 0xFFL) << 48) + (((long)bytes[i8 + 7] & 0xFFL) << 56);
            k *= -4132994306676758123L;
            k ^= k >>> 47;
            h ^= (k *= -4132994306676758123L);
            h *= -4132994306676758123L;
        }
        switch (length % 8) {
            case 7: {
                h ^= (long)(bytes[(length & 0xFFFFFFF8) + 6] & 0xFF) << 48;
            }
            case 6: {
                h ^= (long)(bytes[(length & 0xFFFFFFF8) + 5] & 0xFF) << 40;
            }
            case 5: {
                h ^= (long)(bytes[(length & 0xFFFFFFF8) + 4] & 0xFF) << 32;
            }
            case 4: {
                h ^= (long)(bytes[(length & 0xFFFFFFF8) + 3] & 0xFF) << 24;
            }
            case 3: {
                h ^= (long)(bytes[(length & 0xFFFFFFF8) + 2] & 0xFF) << 16;
            }
            case 2: {
                h ^= (long)(bytes[(length & 0xFFFFFFF8) + 1] & 0xFF) << 8;
            }
            case 1: {
                h ^= (long)(bytes[length & 0xFFFFFFF8] & 0xFF);
                h *= -4132994306676758123L;
            }
        }
        h ^= h >>> 47;
        h *= -4132994306676758123L;
        h ^= h >>> 47;
        return h;
    }

    public int hashCode() {
        int hashCode = 86028157;
        hashCode = 37 * hashCode + this.seed;
        return hashCode;
    }
}

