/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.serializer.collection;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.serializer.TypeSerializer;
import java.util.Map;

public abstract class MapSerializer<T extends Map>
implements TypeSerializer<T> {
    protected abstract T createMap(int var1);

    @Override
    public void write(T object, BufferOutput buffer, Serializer serializer) {
        buffer.writeUnsignedShort(object.size());
        for (Map.Entry entry : object.entrySet()) {
            serializer.writeObject(entry.getKey(), buffer);
            serializer.writeObject(entry.getValue(), buffer);
        }
    }

    @Override
    public T read(Class<T> type, BufferInput buffer, Serializer serializer) {
        int size = buffer.readUnsignedShort();
        T object = this.createMap(size);
        for (int i = 0; i < size; ++i) {
            Object key = serializer.readObject(buffer);
            Object value = serializer.readObject(buffer);
            object.put(key, value);
        }
        return object;
    }
}

