/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.transport;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.CatalystSerializable;
import io.atomix.catalyst.serializer.SerializeWith;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import java.net.InetSocketAddress;

@SerializeWith(id=299)
public class Address
implements CatalystSerializable {
    private InetSocketAddress address;

    public Address() {
    }

    public Address(Address address) {
        this(((Address)Assert.notNull((Object)address, (String)"address")).address);
    }

    public Address(String host, int port) {
        this(new InetSocketAddress(host, port));
    }

    public Address(InetSocketAddress address) {
        this.address = (InetSocketAddress)Assert.notNull((Object)address, (String)"address");
    }

    public String host() {
        return this.address.getHostString();
    }

    public int port() {
        return this.address.getPort();
    }

    public InetSocketAddress socketAddress() {
        return this.address;
    }

    public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        serializer.writeObject((Object)this.address, buffer);
    }

    public void readObject(BufferInput<?> buffer, Serializer serializer) {
        this.address = (InetSocketAddress)serializer.readObject(buffer);
    }

    public boolean equals(Object object) {
        return object instanceof Address && ((Address)object).address.equals(this.address);
    }

    public int hashCode() {
        int hashCode = 23;
        hashCode = 37 * hashCode + this.address.hashCode();
        return hashCode;
    }

    public String toString() {
        return String.format("%s[%s]", this.getClass().getSimpleName(), this.address);
    }
}

