/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.client.session;

import io.atomix.catalyst.concurrent.Futures;
import io.atomix.catalyst.concurrent.Listener;
import io.atomix.catalyst.concurrent.ThreadContext;
import io.atomix.catalyst.transport.Client;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.Command;
import io.atomix.copycat.Operation;
import io.atomix.copycat.Query;
import io.atomix.copycat.client.ConnectionStrategy;
import io.atomix.copycat.client.session.ClientSequencer;
import io.atomix.copycat.client.session.ClientSessionListener;
import io.atomix.copycat.client.session.ClientSessionManager;
import io.atomix.copycat.client.session.ClientSessionState;
import io.atomix.copycat.client.session.ClientSessionSubmitter;
import io.atomix.copycat.client.util.AddressSelector;
import io.atomix.copycat.client.util.ClientConnection;
import io.atomix.copycat.session.ClosedSessionException;
import io.atomix.copycat.session.Session;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class ClientSession
implements Session {
    private final ClientSessionState state;
    private final ClientConnection connection;
    private final ClientSessionManager manager;
    private final ClientSessionListener listener;
    private final ClientSessionSubmitter submitter;

    public ClientSession(String id, Client client, AddressSelector selector, ThreadContext context, ConnectionStrategy connectionStrategy, Duration sessionTimeout, Duration unstabilityTimeout) {
        this(new ClientConnection(id, client, selector), new ClientSessionState(id, unstabilityTimeout), context, connectionStrategy, sessionTimeout);
    }

    private ClientSession(ClientConnection connection, ClientSessionState state, ThreadContext context, ConnectionStrategy connectionStrategy, Duration sessionTimeout) {
        this.connection = (ClientConnection)Assert.notNull((Object)connection, (String)"connection");
        this.state = (ClientSessionState)Assert.notNull((Object)state, (String)"state");
        this.manager = new ClientSessionManager(connection, state, context, connectionStrategy, sessionTimeout);
        ClientSequencer sequencer = new ClientSequencer(state);
        this.listener = new ClientSessionListener(connection, state, sequencer, context);
        this.submitter = new ClientSessionSubmitter(connection, state, sequencer, context);
    }

    public long id() {
        return this.state.getSessionId();
    }

    public Session.State state() {
        return this.state.getState();
    }

    public Listener<Session.State> onStateChange(Consumer<Session.State> callback) {
        return this.state.onStateChange(callback);
    }

    public <T> CompletableFuture<T> submit(Operation<T> operation) {
        if (operation instanceof Query) {
            return this.submit((Query)operation);
        }
        if (operation instanceof Command) {
            return this.submit((Command)operation);
        }
        throw new UnsupportedOperationException("unknown operation type: " + operation.getClass());
    }

    public <T> CompletableFuture<T> submit(Command<T> command) {
        Session.State state = this.state();
        if (state == Session.State.CLOSED || state == Session.State.EXPIRED) {
            return Futures.exceptionalFuture((Throwable)new ClosedSessionException("session closed"));
        }
        return this.submitter.submit(command);
    }

    public <T> CompletableFuture<T> submit(Query<T> query) {
        Session.State state = this.state();
        if (state == Session.State.CLOSED || state == Session.State.EXPIRED) {
            return Futures.exceptionalFuture((Throwable)new ClosedSessionException("session closed"));
        }
        return this.submitter.submit(query);
    }

    public CompletableFuture<Session> register() {
        return this.manager.open().thenApply(v -> this);
    }

    public Listener<Void> onEvent(String event, Runnable callback) {
        return this.listener.onEvent(event, callback);
    }

    public <T> Listener<T> onEvent(String event, Consumer<T> callback) {
        return this.listener.onEvent(event, callback);
    }

    public CompletableFuture<Void> close() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        ((CompletableFuture)((CompletableFuture)this.submitter.close().thenCompose(v -> this.listener.close())).thenCompose(v -> this.manager.close())).whenComplete((managerResult, managerError) -> this.connection.close().whenComplete((connectionResult, connectionError) -> {
            if (managerError != null) {
                future.completeExceptionally((Throwable)managerError);
            } else if (connectionError != null) {
                future.completeExceptionally((Throwable)connectionError);
            } else {
                future.complete(null);
            }
        }));
        return future;
    }

    public CompletableFuture<Void> expire() {
        return this.manager.expire();
    }

    public CompletableFuture<Void> kill() {
        return ((CompletableFuture)((CompletableFuture)this.submitter.close().thenCompose(v -> this.listener.close())).thenCompose(v -> this.manager.kill())).thenCompose(v -> this.connection.close());
    }

    public int hashCode() {
        int hashCode = 31;
        long id = this.id();
        hashCode = 37 * hashCode + (int)(id ^ id >>> 32);
        return hashCode;
    }

    public boolean equals(Object object) {
        return object instanceof ClientSession && ((ClientSession)object).id() == this.id();
    }

    public String toString() {
        return String.format("%s[id=%d]", this.getClass().getSimpleName(), this.id());
    }
}

