/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.protocol;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.protocol.AbstractRequest;
import java.util.Objects;
import java.util.UUID;

public class ConnectRequest
extends AbstractRequest {
    private UUID client;

    public static Builder builder() {
        return new Builder(new ConnectRequest());
    }

    public static Builder builder(ConnectRequest request) {
        return new Builder(request);
    }

    public UUID client() {
        return this.client;
    }

    @Override
    public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        super.writeObject(buffer, serializer);
        buffer.writeString(this.client.toString());
    }

    @Override
    public void readObject(BufferInput<?> buffer, Serializer serializer) {
        super.readObject(buffer, serializer);
        this.client = UUID.fromString(buffer.readString());
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.client);
    }

    public boolean equals(Object object) {
        return object instanceof ConnectRequest && ((ConnectRequest)object).client.equals(this.client);
    }

    public String toString() {
        return String.format("%s[client=%s]", this.getClass().getSimpleName(), this.client);
    }

    public static class Builder
    extends AbstractRequest.Builder<Builder, ConnectRequest> {
        protected Builder(ConnectRequest request) {
            super(request);
        }

        public Builder withClientId(UUID clientId) {
            ((ConnectRequest)this.request).client = (UUID)Assert.notNull((Object)clientId, (String)"clientId");
            return this;
        }

        @Override
        public ConnectRequest build() {
            super.build();
            Assert.stateNot((((ConnectRequest)this.request).client == null ? 1 : 0) != 0, (String)"client cannot be null", (Object[])new Object[0]);
            return (ConnectRequest)this.request;
        }
    }
}

