/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.protocol;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.Command;
import io.atomix.copycat.Operation;
import io.atomix.copycat.protocol.OperationRequest;
import java.util.Objects;

public class CommandRequest
extends OperationRequest {
    private Command command;

    public static Builder builder() {
        return new Builder(new CommandRequest());
    }

    public static Builder builder(CommandRequest request) {
        return new Builder(request);
    }

    public Command command() {
        return this.command;
    }

    @Override
    public Operation operation() {
        return this.command;
    }

    public void readObject(BufferInput buffer, Serializer serializer) {
        super.readObject(buffer, serializer);
        this.command = (Command)serializer.readObject(buffer);
    }

    public void writeObject(BufferOutput buffer, Serializer serializer) {
        super.writeObject(buffer, serializer);
        serializer.writeObject((Object)this.command, buffer);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.session, this.sequence, this.command);
    }

    public boolean equals(Object object) {
        if (object instanceof CommandRequest) {
            CommandRequest request = (CommandRequest)object;
            return request.session == this.session && request.sequence == this.sequence && request.command.equals(this.command);
        }
        return false;
    }

    public String toString() {
        return String.format("%s[session=%d, sequence=%d, command=%s]", this.getClass().getSimpleName(), this.session, this.sequence, this.command);
    }

    public static class Builder
    extends OperationRequest.Builder<Builder, CommandRequest> {
        protected Builder(CommandRequest request) {
            super(request);
        }

        public Builder withCommand(Command command) {
            ((CommandRequest)this.request).command = (Command)Assert.notNull((Object)command, (String)"command");
            return this;
        }

        @Override
        public CommandRequest build() {
            super.build();
            Assert.stateNot((((CommandRequest)this.request).command == null ? 1 : 0) != 0, (String)"command cannot be null", (Object[])new Object[0]);
            return (CommandRequest)this.request;
        }
    }
}

