/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.protocol;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.copycat.error.CopycatError;
import io.atomix.copycat.protocol.AbstractResponse;
import io.atomix.copycat.protocol.Response;
import java.util.Objects;

public class AcceptResponse
extends AbstractResponse {
    public static Builder builder() {
        return new Builder(new AcceptResponse());
    }

    public static Builder builder(AcceptResponse response) {
        return new Builder(response);
    }

    public void readObject(BufferInput buffer, Serializer serializer) {
        this.status = Response.Status.forId((int)buffer.readByte());
        this.error = this.status == Response.Status.OK ? null : CopycatError.forId((int)buffer.readByte());
    }

    public void writeObject(BufferOutput buffer, Serializer serializer) {
        buffer.writeByte((int)this.status.id());
        if (this.status == Response.Status.ERROR) {
            buffer.writeByte((int)this.error.id());
        }
    }

    public int hashCode() {
        return Objects.hash(((Object)((Object)this)).getClass(), this.status);
    }

    public boolean equals(Object object) {
        if (object instanceof AcceptResponse) {
            AcceptResponse response = (AcceptResponse)((Object)object);
            return response.status == this.status;
        }
        return false;
    }

    public String toString() {
        return String.format("%s[status=%s]", ((Object)((Object)this)).getClass().getSimpleName(), this.status);
    }

    public static class Builder
    extends AbstractResponse.Builder<Builder, AcceptResponse> {
        protected Builder(AcceptResponse response) {
            super((AbstractResponse)response);
        }
    }
}

