/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.state;

import io.atomix.catalyst.transport.Connection;
import io.atomix.catalyst.util.Managed;
import io.atomix.copycat.protocol.CommandRequest;
import io.atomix.copycat.protocol.CommandResponse;
import io.atomix.copycat.protocol.ConnectRequest;
import io.atomix.copycat.protocol.ConnectResponse;
import io.atomix.copycat.protocol.KeepAliveRequest;
import io.atomix.copycat.protocol.KeepAliveResponse;
import io.atomix.copycat.protocol.PublishRequest;
import io.atomix.copycat.protocol.PublishResponse;
import io.atomix.copycat.protocol.QueryRequest;
import io.atomix.copycat.protocol.QueryResponse;
import io.atomix.copycat.protocol.RegisterRequest;
import io.atomix.copycat.protocol.RegisterResponse;
import io.atomix.copycat.protocol.Request;
import io.atomix.copycat.protocol.Response;
import io.atomix.copycat.protocol.UnregisterRequest;
import io.atomix.copycat.protocol.UnregisterResponse;
import io.atomix.copycat.server.CopycatServer;
import io.atomix.copycat.server.protocol.AcceptRequest;
import io.atomix.copycat.server.protocol.AcceptResponse;
import io.atomix.copycat.server.protocol.AppendRequest;
import io.atomix.copycat.server.protocol.AppendResponse;
import io.atomix.copycat.server.protocol.ConfigureRequest;
import io.atomix.copycat.server.protocol.ConfigureResponse;
import io.atomix.copycat.server.protocol.InstallRequest;
import io.atomix.copycat.server.protocol.InstallResponse;
import io.atomix.copycat.server.protocol.JoinRequest;
import io.atomix.copycat.server.protocol.JoinResponse;
import io.atomix.copycat.server.protocol.LeaveRequest;
import io.atomix.copycat.server.protocol.LeaveResponse;
import io.atomix.copycat.server.protocol.PollRequest;
import io.atomix.copycat.server.protocol.PollResponse;
import io.atomix.copycat.server.protocol.ReconfigureRequest;
import io.atomix.copycat.server.protocol.ReconfigureResponse;
import io.atomix.copycat.server.protocol.VoteRequest;
import io.atomix.copycat.server.protocol.VoteResponse;
import io.atomix.copycat.server.state.ServerContext;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractState
implements Managed<AbstractState> {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    protected final ServerContext context;
    private boolean open = true;

    protected AbstractState(ServerContext context) {
        this.context = context;
    }

    public abstract CopycatServer.State type();

    protected final <R extends Request> R logRequest(R request) {
        this.LOGGER.debug("{} - Received {}", (Object)this.context.getCluster().member().address(), request);
        return request;
    }

    protected final <R extends Response> R logResponse(R response) {
        this.LOGGER.debug("{} - Sent {}", (Object)this.context.getCluster().member().address(), response);
        return response;
    }

    public CompletableFuture<AbstractState> open() {
        this.context.checkThread();
        this.open = true;
        return CompletableFuture.completedFuture(null);
    }

    public boolean isOpen() {
        return this.open;
    }

    protected <T extends Request, U extends Response> CompletableFuture<U> forward(T request) {
        CompletableFuture future = new CompletableFuture();
        this.context.getConnections().getConnection(this.context.getLeader().serverAddress()).whenComplete((connection, connectError) -> {
            if (connectError == null) {
                connection.send((Object)request).whenComplete((response, responseError) -> {
                    if (responseError == null) {
                        future.complete(response);
                    } else {
                        future.completeExceptionally((Throwable)responseError);
                    }
                });
            } else {
                future.completeExceptionally((Throwable)connectError);
            }
        });
        return future;
    }

    protected boolean updateTermAndLeader(long term, int leader) {
        if (term > this.context.getTerm() || term == this.context.getTerm() && this.context.getLeader() == null && leader != 0) {
            this.context.setTerm(term);
            this.context.setLeader(leader);
            this.context.getClusterState().reset();
            return true;
        }
        return false;
    }

    protected abstract CompletableFuture<RegisterResponse> register(RegisterRequest var1);

    protected abstract CompletableFuture<ConnectResponse> connect(ConnectRequest var1, Connection var2);

    protected abstract CompletableFuture<AcceptResponse> accept(AcceptRequest var1);

    protected abstract CompletableFuture<KeepAliveResponse> keepAlive(KeepAliveRequest var1);

    protected abstract CompletableFuture<UnregisterResponse> unregister(UnregisterRequest var1);

    protected abstract CompletableFuture<PublishResponse> publish(PublishRequest var1);

    protected abstract CompletableFuture<ConfigureResponse> configure(ConfigureRequest var1);

    protected abstract CompletableFuture<InstallResponse> install(InstallRequest var1);

    protected abstract CompletableFuture<JoinResponse> join(JoinRequest var1);

    protected abstract CompletableFuture<ReconfigureResponse> reconfigure(ReconfigureRequest var1);

    protected abstract CompletableFuture<LeaveResponse> leave(LeaveRequest var1);

    protected abstract CompletableFuture<AppendResponse> append(AppendRequest var1);

    protected abstract CompletableFuture<PollResponse> poll(PollRequest var1);

    protected abstract CompletableFuture<VoteResponse> vote(VoteRequest var1);

    protected abstract CompletableFuture<CommandResponse> command(CommandRequest var1);

    protected abstract CompletableFuture<QueryResponse> query(QueryRequest var1);

    public CompletableFuture<Void> close() {
        this.context.checkThread();
        this.open = false;
        return CompletableFuture.completedFuture(null);
    }

    public boolean isClosed() {
        return !this.open;
    }

    public String toString() {
        return String.format("%s[context=%s]", this.getClass().getSimpleName(), this.context);
    }
}

